/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.Quaternion;
import com.takyon.gamelib.Vector3d;

public class Matrix3x3 {
    float[][] value = new float[3][3];

    public Matrix3x3() {
        int i = 0;
        while (i < 2) {
            this.value[i][i] = 1.0f;
            ++i;
        }
    }

    public Matrix3x3(Quaternion q) {
        this.value[0][0] = 1.0f - 2.0f * (q.getY() * q.getY() + q.getZ() * q.getZ());
        this.value[0][1] = 2.0f * (q.getX() * q.getY() + q.getZ() * q.getW());
        this.value[0][2] = 2.0f * (q.getX() * q.getZ() - q.getY() * q.getW());
        this.value[1][0] = 2.0f * (q.getX() * q.getY() - q.getZ() * q.getW());
        this.value[1][1] = 1.0f - 2.0f * (q.getX() * q.getX() + q.getZ() * q.getZ());
        this.value[1][2] = 2.0f * (q.getZ() * q.getY() + q.getX() * q.getW());
        this.value[2][0] = 2.0f * (q.getX() * q.getZ() + q.getY() * q.getW());
        this.value[2][1] = 2.0f * (q.getY() * q.getZ() - q.getX() * q.getW());
        this.value[2][2] = 1.0f - 2.0f * (q.getX() * q.getX() + q.getY() * q.getY());
    }

    public void rotate3(Vector3d pyr) {
        float a = (float)Math.cos(pyr.x);
        float b = (float)Math.sin(pyr.x);
        float c = (float)Math.cos(pyr.y);
        float d = (float)Math.sin(pyr.y);
        float e = (float)Math.cos(pyr.z);
        float f = (float)Math.sin(pyr.z);
        float ad = a * d;
        float bd = b * d;
        this.value[0][0] = c * e;
        this.value[1][0] = -c * f;
        this.value[2][0] = d;
        this.value[0][1] = bd * e + a * f;
        this.value[1][1] = -bd * f + a * e;
        this.value[2][1] = -b * c;
        this.value[0][2] = -ad * e + b * f;
        this.value[1][2] = ad * f + b * e;
        this.value[2][2] = a * c;
    }

    public void rotate3(float angle, Vector3d axis) {
        float cosA = (float)Math.cos(Math.toRadians(angle));
        float sinA = (float)Math.sin(Math.toRadians(angle));
        this.value[0][0] = cosA + (1.0f - cosA) * axis.x * axis.x;
        this.value[1][0] = (1.0f - cosA) * axis.x * axis.y - axis.z * sinA;
        this.value[2][0] = (1.0f - cosA) * axis.x * axis.z + axis.y * sinA;
        this.value[0][1] = (1.0f - cosA) * axis.x * axis.z + axis.z * sinA;
        this.value[1][1] = cosA + (1.0f - cosA) * axis.y * axis.y;
        this.value[2][1] = (1.0f - cosA) * axis.y * axis.z - axis.x * sinA;
        this.value[0][2] = (1.0f - cosA) * axis.x * axis.z - axis.y * sinA;
        this.value[1][2] = (1.0f - cosA) * axis.y * axis.z + axis.x * sinA;
        this.value[2][2] = cosA + (1.0f - cosA) * axis.z * axis.z;
    }
}

