/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.Point;
import com.takyon.gamelib.Vector2d;
import com.takyon.gamelib.Vector3d;

public class Segment {
    public Point p1;
    public Point p2;

    public Segment() {
        this.p1 = new Point(0.0f, 0.0f);
        this.p2 = new Point(0.0f, 0.0f);
    }

    public Segment(Point point1, Point point2) {
        if (point1.x <= point2.x) {
            this.p1 = point1;
            this.p2 = point2;
        } else {
            this.p1 = point2;
            this.p2 = point1;
        }
    }

    public Segment translate(Vector2d vector) {
        return new Segment(this.p1.getTranslatedPoint(vector), this.p2.getTranslatedPoint(vector));
    }

    public Point getPointAtDistance(float distance, int direction) {
        Point origine;
        float m = (this.p2.y - this.p1.y) / (this.p2.x - this.p1.x);
        if (direction == -1) {
            origine = this.p2;
            Point extremite = this.p1;
        } else {
            origine = this.p1;
            Point extremite = this.p2;
        }
        float newX = origine.x + (float)direction * distance / (float)Math.sqrt(1.0f + m * m);
        return new Point(newX, m * (newX - origine.x) + origine.y);
    }

    public Vector3d toVector() {
        return new Vector3d(this.p1, this.p2);
    }

    public String toString() {
        return "Segment :\n" + this.p1 + this.p2;
    }
}

