/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.Animation;
import com.takyon.gamelib.DrawableObject;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Rectangle;
import com.takyon.gamelib.Scene2D;
import com.takyon.gamelib.SpriteAnimation;
import com.takyon.gamelib.Texture;
import java.util.ArrayList;

public class Sprite
extends DrawableObject {
    public transient Animation currentAnimation;
    public ArrayList<SpriteAnimation> spriteAnimations = new ArrayList();
    public float angle;
    public Rectangle rectangle = new Rectangle();
    public boolean isAnimating = false;

    @Override
    public Position getPositionScale() {
        return new Position(this.getPosition().x * Scene2D.RATIO, ((float)Scene2D.SCREEN_HEIGHT_BASE - this.getPosition().y) * Scene2D.RATIO - this.getHeight());
    }

    public void setRotation(float angle) {
        this.angle = angle;
    }

    public void addAnimation(SpriteAnimation spriteAnimation) {
        this.spriteAnimations.add(spriteAnimation);
    }

    public void setAnimation(Animation spriteAnimation) {
        this.currentAnimation = spriteAnimation;
    }

    public void animate(float dt) {
        this.currentAnimation.run(dt);
    }

    public void setMirror(boolean isMirror) {
        ((SpriteAnimation)this.currentAnimation).isMirror = isMirror;
    }

    @Override
    public void draw() {
        this.currentAnimation.draw();
    }

    public float getWidth() {
        return ((SpriteAnimation)this.currentAnimation).texturedRectangle.width;
    }

    public float getHeight() {
        return ((SpriteAnimation)this.currentAnimation).texturedRectangle.height;
    }

    public Texture getTexture() {
        return ((SpriteAnimation)this.currentAnimation).texturedRectangle.texture;
    }

    public Rectangle getRectangle() {
        Position position = this.getPositionScale();
        this.rectangle.x = position.x;
        this.rectangle.y = position.y + this.getHeight();
        this.rectangle.width = this.getWidth();
        this.rectangle.height = this.getHeight();
        return this.rectangle;
    }
}

