/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.Point;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Vector3d;

public class Vector2d {
    public float x;
    public float y;

    public Vector2d() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public Vector2d(Vector2d v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vector2d(Point a, Point b) {
        this.x = b.x - a.x;
        this.y = b.y - a.y;
    }

    public Vector2d(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2d(Position a, Position b) {
        this.x = b.x - a.x;
        this.y = b.y - a.y;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(Vector2d v) {
        this.x = v.x;
        this.y = v.y;
    }

    public void set(Position a, Position b) {
        this.x = b.x - a.x;
        this.y = b.y - a.y;
    }

    public void set(Point a, Point b) {
        this.x = b.x - a.x;
        this.y = b.y - a.y;
    }

    public Vector2d addVec(Vector2d v) {
        return new Vector2d(this.x + v.x, this.y + v.y);
    }

    public void add(Vector2d v) {
        this.x += v.x;
        this.y += v.y;
    }

    public void sub(Vector2d v) {
        this.x -= v.x;
        this.y -= v.y;
    }

    public Vector2d subVec(Vector2d v) {
        return new Vector2d(this.x - v.x, this.y - v.y);
    }

    public void scale(float s) {
        this.x *= s;
        this.y *= s;
    }

    public Vector2d scalev(float s) {
        return new Vector2d(this.x * s, this.y * s);
    }

    public float dotProduct(Vector2d v) {
        return this.x * v.x + this.y * v.y;
    }

    public float det(Vector2d v) {
        return this.x * v.y - this.y * v.x;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public void normalize() {
        float l = this.length();
        if (l == 0.0f) {
            this.x = 0.0f;
            this.y = 0.0f;
        } else {
            this.x /= l;
            this.y /= l;
        }
    }

    public Vector2d normalVec() {
        float l = this.length();
        return new Vector2d(this.x / l, this.y / l);
    }

    public float unsignedAngle() {
        Vector2d v = new Vector2d(1.0f, 0.0f);
        return (float)Math.toDegrees(Math.acos(this.dotProduct(v) / (this.length() * v.length())));
    }

    public Vector3d crossProd(Vector2d v) {
        return new Vector3d(0.0f, 0.0f, this.x * v.y - this.y * v.x);
    }

    public float angle() {
        return (float)(-this.crossProd(new Vector2d(1.0f, 0.0f)).zsign()) * this.unsignedAngle();
    }

    public float angle(Vector2d v) {
        return (float)((double)(-Math.signum(this.det(v))) * Math.toDegrees(Math.acos(this.dotProduct(v) / (this.length() * v.length()))));
    }

    public Vector2d rotateZ(float a) {
        float t = this.x / this.y;
        float ay = (float)((Math.cos(a) + Math.sin(a) * (double)t) / (double)(this.x + this.y * t));
        float ax = (float)Math.cos(a) - ay * this.y / this.x;
        return new Vector2d(ax, ay);
    }

    public boolean isIn(float x1, float y1, float x2, float y2) {
        return this.x > x1 && this.x < x2 && this.y > y1 && this.y < y2;
    }

    public Vector3d toXYZ() {
        return new Vector3d(this.x, this.y, 0.0f);
    }

    public String toString() {
        return "<" + this.x + "," + this.y + ">";
    }
}

