/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib.network;

import com.takyon.gamelib.AbstractClient;
import com.takyon.gamelib.AbstractMessage;
import com.takyon.gamelib.network.Client;
import com.takyon.gamelib.network.ClientThread;
import com.takyon.gamelib.network.Partie;
import com.takyon.gamelib.network.PlayerNet;
import com.takyon.gamelib.network.server.ConnectionAcceptedMessage;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Random;

public class Server {
    public static HashMap<Integer, PlayerNet> joueurs = new HashMap();
    public static HashMap<Integer, Client> clients = new HashMap();
    public static HashMap<Integer, Partie> games = new HashMap();
    private static int nbClients = 0;
    private static int currentId = 1;
    private static boolean finished = false;
    public static Random rand = new Random();

    public static void main(String[] args) {
        Server server = new Server();
        try {
            Integer port = args.length == 0 ? new Integer("12211") : new Integer(args[0]);
            ServerSocket serverSocket = new ServerSocket(port);
            System.out.println("--------");
            System.out.println("Demarre sur le port : " + port.toString());
            System.out.println("--------");
            while (!finished) {
                Socket clientSocket = serverSocket.accept();
                Client client = new Client(clientSocket, (int)port);
                ++currentId;
                client.id = client.id;
                Server.addClient(client);
                ConnectionAcceptedMessage msg = new ConnectionAcceptedMessage(client.id);
                Server.send((AbstractMessage)msg, client);
                new ClientThread(client).start();
            }
            serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void send(AbstractMessage msg, int id) {
        msg.destID = id;
        Server.send(msg);
    }

    public static synchronized void send(AbstractMessage msg, AbstractClient client) {
        try {
            client.out.writeObject(msg);
            client.out.flush();
            client.out.reset();
            System.out.println("server sends message to : " + msg.destID);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            System.out.println("Server error " + msg.destID + " n existe pas");
        }
    }

    public static synchronized void send(AbstractMessage msg) {
        msg.senderID = 0;
        Client client = clients.get(msg.destID);
        Server.send(msg, client);
    }

    public static synchronized void sendAll(AbstractMessage msg) {
        for (Client client : clients.values()) {
            Server.send(msg, client);
        }
    }

    public static synchronized void deleteClient(int i) {
        if (clients.get(i) != null) {
            clients.remove(i);
        }
    }

    public static synchronized void deleteJoueur(int i) {
        if (joueurs.get(i) != null) {
            joueurs.remove(i);
        }
    }

    public static synchronized void addClient(Client client) {
        clients.put(client.id, client);
    }

    public static synchronized void addJoueur(PlayerNet joueur) {
        joueurs.put(joueur.id, joueur);
    }

    public static synchronized int getNbClients() {
        return joueurs.size();
    }
}

