/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.squares;

import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.Scene2D;
import com.takyon.squares.Cell;
import com.takyon.squares.SquaresMain;
import com.takyon.squares.screens.SquareScreenGame;

public class Grid {
    public int nbCols;
    public int nbRows;
    public Cell[][] cells;
    public int posX;
    public int posY;
    private float gap;
    private float size;
    public static GDXImage img_noeud;
    public static GDXImage[] img_barre_horizontale;
    public static GDXImage[] img_barre_verticale;
    public static GDXImage[] img_carre;

    public Grid(int nbCols, int nbRows) {
        this.nbCols = nbCols;
        this.nbRows = nbRows;
        this.cells = new Cell[nbCols][nbRows];
        this.gap = 64.0f * Scene2D.RATIO;
        this.size = 128.0f * Scene2D.RATIO;
        this.posX = 400;
        this.posY = 600;
    }

    public static void initGraphics() {
        img_noeud = new GDXImage("kit_square/images/noeud.png");
        img_barre_horizontale = new GDXImage[3];
        Grid.img_barre_horizontale[0] = new GDXImage("kit_square/images/barre_horizontale.png");
        Grid.img_barre_horizontale[1] = new GDXImage("kit_square/images/barre_horizontale_bleu.png");
        Grid.img_barre_horizontale[2] = new GDXImage("kit_square/images/barre_horizontale_rouge.png");
        img_barre_verticale = new GDXImage[3];
        Grid.img_barre_verticale[0] = new GDXImage("kit_square/images/barre_verticale.png");
        Grid.img_barre_verticale[1] = new GDXImage("kit_square/images/barre_verticale_bleu.png");
        Grid.img_barre_verticale[2] = new GDXImage("kit_square/images/barre_verticale_rouge.png");
        img_carre = new GDXImage[3];
        Grid.img_carre[0] = new GDXImage("kit_square/images/carre_vide.png");
        Grid.img_carre[1] = new GDXImage("kit_square/images/carre_bleu.png");
        Grid.img_carre[2] = new GDXImage("kit_square/images/carre_rouge.png");
    }

    public int getValue(int i, int j, int dir) {
        Cell cell = this.getCell(i, j);
        if (cell != null) {
            switch (dir) {
                case 0: {
                    return cell.north;
                }
                case 1: {
                    return cell.east;
                }
                case 2: {
                    return cell.south;
                }
                case 3: {
                    return cell.west;
                }
            }
        }
        return 0;
    }

    public void setValue(int player, int i, int j, int dir) {
        Cell cell = this.getCell(i, j);
        if (cell != null) {
            switch (dir) {
                case 0: {
                    cell.north = player;
                    return;
                }
                case 1: {
                    cell.east = player;
                    return;
                }
                case 2: {
                    cell.south = player;
                    return;
                }
                case 3: {
                    cell.west = player;
                    return;
                }
            }
        }
    }

    public void onClick(int player, float x, float y) {
        int j;
        y = 720.0f - y;
        int i = 0;
        while (i < this.nbCols) {
            j = 0;
            while (j <= this.nbRows) {
                if (x >= (float)this.posX + (float)i * (this.gap + this.size) + this.gap && x <= (float)this.posX + (float)i * (this.gap + this.size) + this.gap + this.size && y <= (float)this.posY - (float)j * (this.gap + this.size) && y >= (float)this.posY - (float)j * (this.gap + this.size) - this.gap) {
                    int val1 = this.getValue(i, j - 1, 2);
                    int val2 = this.getValue(i, j, 0);
                    if (val1 == 0 && val2 == 0) {
                        this.setValue(player, i, j - 1, 2);
                        this.setValue(player, i, j, 0);
                        boolean check1 = this.checkCellEntoure(i, j - 1);
                        boolean check2 = this.checkCellEntoure(i, j);
                        if (!check1 && !check2) {
                            SquaresMain.switchPlayer();
                        }
                    }
                    return;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i <= this.nbCols) {
            j = 0;
            while (j < this.nbRows) {
                if (x >= (float)this.posX + (float)i * (this.gap + this.size) && x <= (float)this.posX + (float)i * (this.gap + this.size) + this.size && y <= (float)this.posY - (float)j * (this.gap + this.size) - this.gap && y >= (float)this.posY - (float)j * (this.gap + this.size) - this.gap - this.size) {
                    int val1 = this.getValue(i - 1, j, 1);
                    int val2 = this.getValue(i, j, 3);
                    if (val1 == 0 && val2 == 0) {
                        this.setValue(player, i - 1, j, 1);
                        this.setValue(player, i, j, 3);
                        boolean check1 = this.checkCellEntoure(i - 1, j);
                        boolean check2 = this.checkCellEntoure(i, j);
                        if (!check1 && !check2) {
                            SquaresMain.switchPlayer();
                        }
                    }
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean checkCellEntoure(int i, int j) {
        Cell cell = this.getCell(i, j);
        if (cell != null && cell.isComplete()) {
            cell.winner = SquaresMain.currentPlayer;
            SquareScreenGame.setScore(this.getNBCellsPlayer1(), this.getNBCellsPlayer2());
            if (this.isComplete()) {
                int winner = this.getWinner();
                if (winner == 0) {
                    SquareScreenGame.txt_winner.setText("MATCH NUL !");
                } else {
                    SquareScreenGame.txt_winner.setText("THE WINNER IS PLAYER " + this.getWinner());
                }
            }
            return true;
        }
        return false;
    }

    private int getNBCellsPlayer1() {
        int nb = 0;
        int i = 0;
        while (i < this.nbCols) {
            int j = 0;
            while (j < this.nbRows) {
                Cell cell = this.cells[i][j];
                if (cell.winner == 1) {
                    ++nb;
                }
                ++j;
            }
            ++i;
        }
        return nb;
    }

    private int getNBCellsPlayer2() {
        int nb = 0;
        int i = 0;
        while (i < this.nbCols) {
            int j = 0;
            while (j < this.nbRows) {
                Cell cell = this.cells[i][j];
                if (cell.winner == 2) {
                    ++nb;
                }
                ++j;
            }
            ++i;
        }
        return nb;
    }

    private Cell getCell(int i, int j) {
        if (i >= 0 && i < this.nbCols && j >= 0 && j < this.nbRows) {
            return this.cells[i][j];
        }
        return null;
    }

    public boolean isComplete() {
        int i = 0;
        while (i < this.nbCols) {
            int j = 0;
            while (j < this.nbRows) {
                Cell cell = this.cells[i][j];
                if (!cell.isComplete()) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public int getWinner() {
        int nbCellsPlayer2;
        int nbCellsPlayer1 = this.getNBCellsPlayer1();
        if (nbCellsPlayer1 > (nbCellsPlayer2 = this.getNBCellsPlayer2())) {
            return 1;
        }
        if (nbCellsPlayer1 < nbCellsPlayer2) {
            return 2;
        }
        return 0;
    }

    public void drawImage(GDXImage image, float x, float y) {
        image.draw(x, y - image.getHeight() * Scene2D.RATIO);
    }

    public void draw() {
        int j;
        int i = 0;
        while (i <= this.nbCols) {
            j = 0;
            while (j <= this.nbRows) {
                this.drawImage(img_noeud, (float)this.posX + (float)i * (this.gap + this.size), (float)this.posY - (float)j * (this.gap + this.size));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nbCols) {
            j = 0;
            while (j < this.nbRows) {
                Cell cell = this.getCell(i, j);
                if (cell != null) {
                    this.drawImage(img_carre[cell.winner], (float)this.posX + (float)i * (this.gap + this.size) + this.gap, (float)this.posY - ((float)j * (this.gap + this.size) + this.gap));
                    this.drawImage(img_barre_horizontale[cell.north], (float)this.posX + (float)i * (this.gap + this.size) + this.gap, (float)this.posY - (float)j * (this.gap + this.size));
                    this.drawImage(img_barre_horizontale[cell.south], (float)this.posX + (float)i * (this.gap + this.size) + this.gap, (float)this.posY - ((float)j * (this.gap + this.size) + this.gap + this.size));
                    this.drawImage(img_barre_verticale[cell.west], (float)this.posX + (float)i * (this.gap + this.size), (float)this.posY - ((float)j * (this.gap + this.size) + this.gap));
                    this.drawImage(img_barre_verticale[cell.east], (float)this.posX + (float)i * (this.gap + this.size) + this.gap + this.size, (float)this.posY - ((float)j * (this.gap + this.size) + this.gap));
                }
                ++j;
            }
            ++i;
        }
    }

    public void reset() {
        int i = 0;
        while (i < this.nbCols) {
            int j = 0;
            while (j < this.nbRows) {
                this.cells[i][j] = new Cell(i, j);
                ++j;
            }
            ++i;
        }
    }
}

