/*
 * Decompiled with CFR 0.152.
 */
package com.takyon;

import com.takyon.globals;
import java.awt.Color;
import java.awt.Graphics;

class Ball {
    double Vx = 0.0;
    double Vy = 0.0;
    double Px = 0.0;
    double Py = 0.0;
    double Density = 1.0;
    double Radius;
    double Mass;
    Color BallColor = new Color(0, 0, 0);

    public Ball(double x, double y, double radius) {
        double Volume = 4.1887902047863905 * radius * radius * radius;
        this.Px = x;
        this.Py = y;
        this.Radius = radius;
        this.Mass = this.Density * Volume;
    }

    public void PrintData() {
        System.out.println("Px:" + this.Px);
        System.out.println("Py:" + this.Py);
        System.out.println("Mass:" + this.Mass);
        System.out.println("Vx:  " + this.Vx);
        System.out.println("Vy:  " + this.Vy);
        System.out.println("V:   " + this.Velocity());
        System.out.println("Ek:  " + this.Kinetic());
        System.out.println("Mom: " + this.Momentum());
    }

    public void addVelocity(double x, double y) {
        this.Vx += x;
        this.Vy += y;
    }

    public double Velocity() {
        return Math.sqrt(this.Vx * this.Vx + this.Vy * this.Vy);
    }

    public double Momentum() {
        return this.Mass * this.Vx + this.Mass * this.Vy;
    }

    public double Kinetic() {
        return 0.5 * this.Mass * this.Velocity() * this.Velocity();
    }

    public void WallBounceX() {
        this.Vx = -this.Vx;
    }

    public void WallBounceY() {
        this.Vy = -this.Vy;
    }

    public void Move(double t) {
        this.Px += this.Vx * t;
        this.Py += this.Vy * t;
    }

    public void Draw(Graphics g) {
        int left = (int)(this.Px * (double)globals.DrawScale);
        int top = (int)(this.Py * (double)globals.DrawScale);
        int size = (int)(2.0 * this.Radius * (double)globals.DrawScale);
        g.setColor(this.BallColor);
        g.fillOval(left, top, size, size);
    }

    public void Clear(Graphics g, Color TableColor) {
        int left = (int)(this.Px * (double)globals.DrawScale);
        int top = (int)(this.Py * (double)globals.DrawScale);
        int size = (int)(2.0 * this.Radius * (double)globals.DrawScale);
        g.setColor(TableColor);
        g.fillOval(left - 1, top - 1, size + 2, size + 2);
    }
}

