/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.game.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.takyon.battle.BattleGame;
import com.takyon.gamelib.GameScreen;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Scene2D;

public class BattleInputProcessor
implements InputProcessor {
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        int x = (int)((float)(screenX - Graphics.decalageX) / Scene2D.RATIO);
        int y = (int)((float)screenY / Scene2D.RATIO);
        GameScreen.currentScreen.onTouchDown(x, y, pointer, button);
        return true;
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        int x = (int)((float)(screenX - Graphics.decalageX) / Scene2D.RATIO);
        int y = (int)((float)screenY / Scene2D.RATIO);
        GameScreen.currentScreen.onTouched(x, y, pointer, button);
        return true;
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        int x = (int)((float)(screenX - Graphics.decalageX) / Scene2D.RATIO);
        int y = (int)((float)screenY / Scene2D.RATIO);
        GameScreen.currentScreen.mouseDragged(x, y, pointer);
        BattleGame.pointer.setPosition(x, y);
        return false;
    }

    public boolean mouseMoved(int screenX, int screenY) {
        int x = (int)((float)(screenX - Graphics.decalageX) / Scene2D.RATIO);
        int y = (int)((float)screenY / Scene2D.RATIO);
        GameScreen.currentScreen.mouseMoved(x, y);
        BattleGame.pointer.setPosition(x, y);
        return false;
    }

    public boolean keyDown(int keycode) {
        return false;
    }

    public boolean keyUp(int keycode) {
        GameScreen.currentScreen.keyUp(keycode);
        return false;
    }

    public boolean keyTyped(char character) {
        if (character == 'f') {
            Gdx.graphics.setDisplayMode(Gdx.graphics.getDesktopDisplayMode().width, Gdx.graphics.getDesktopDisplayMode().height, true);
        }
        GameScreen.currentScreen.keyTyped(character);
        return false;
    }

    public boolean scrolled(int amount) {
        return false;
    }
}

