/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.game.physics;

import com.badlogic.gdx.math.Vector2;
import com.takyon.battle.game.pions.PionBattle;
import com.takyon.gamelib.Position;

public class Ball {
    public Position position;
    public Vector2 velocity0;
    public Vector2 velocity;
    public float V0;
    public float V;
    public double density = 1.0;
    public float radius;
    public double mass;
    public PionBattle pion;

    public Ball(PionBattle pion) {
        this.pion = pion;
        this.position = new Position();
        this.velocity0 = new Vector2();
        this.velocity = new Vector2();
    }

    public void setRadius(float radius) {
        this.radius = radius;
        float Volume = (float)(4.1887902047863905 * (double)radius * (double)radius * (double)radius);
        this.mass = this.density * (double)Volume;
    }

    public void addVelocity(float x, float y) {
        this.velocity.x += x;
        this.velocity.y += y;
    }

    public float Velocity() {
        return this.velocity.len();
    }

    public Vector2 UnitVelocity0() {
        Vector2 result = new Vector2();
        float len = this.velocity0.len();
        if (len == 0.0f) {
            result.set(0.0f, 0.0f);
        } else {
            result.set(this.velocity0.x / len, this.velocity0.y / len);
        }
        return result;
    }

    public Vector2 UnitVelocity() {
        Vector2 result = new Vector2();
        float len = this.Velocity();
        if (len == 0.0f) {
            result.set(0.0f, 0.0f);
        } else {
            result.set(this.velocity.x / len, this.velocity.y / len);
        }
        return result;
    }

    public double Momentum() {
        return this.mass * (double)this.velocity.x + this.mass * (double)this.velocity.y;
    }

    public double Kinetic() {
        return 0.5 * this.mass * (double)this.Velocity() * (double)this.Velocity();
    }

    public void WallBounceX() {
        this.velocity0.x = -this.velocity0.x;
        this.pion.bounce();
    }

    public void WallBounceY() {
        this.velocity0.y = -this.velocity0.y;
        this.pion.bounce();
    }

    public void setPosition(float x, float y) {
        this.position.set(x, y);
    }

    public Position getPosition() {
        return this.position;
    }
}

