/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.network.messages.game;

import com.badlogic.gdx.math.Vector2;
import com.takyon.battle.BattleGame;
import com.takyon.battle.game.pions.PionBattle;
import com.takyon.battle.screens.BattleGameScreen;
import com.takyon.chess.game.PlayerColor;
import com.takyon.gamelib.AbstractMessage;
import com.takyon.gamelib.GDXGameNet;

public class CoupMessage
extends AbstractMessage {
    public PlayerColor color;
    public int id;
    public Vector2 aim = new Vector2();

    public CoupMessage() {
    }

    public CoupMessage(PlayerColor color, int id, Vector2 aim) {
        this();
        this.color = color;
        this.id = id;
        this.aim.set(aim);
    }

    private PionBattle getPion() {
        if (this.color == PlayerColor.WHITE) {
            return BattleGame.playerBlue.getPion(this.id);
        }
        if (this.color == PlayerColor.BLACK) {
            return BattleGame.playerRed.getPion(this.id);
        }
        return null;
    }

    @Override
    public void execute() {
        PionBattle pion = this.getPion();
        if (GDXGameNet.playerNet != null) {
            GDXGameNet.playerNet.isWaiting = true;
        }
        BattleGameScreen.screenGame.attack(pion, this.aim);
    }

    public String toString() {
        return "Player " + (Object)((Object)this.color) + " played pion id = " + this.id + " aim : " + this.aim;
    }
}

