/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.screens;

import com.takyon.battle.BattleGame;
import com.takyon.battle.game.ia.BattleIA;
import com.takyon.battle.screens.BattleGameScreen;
import com.takyon.chess.utils.Fonts;
import com.takyon.gamelib.GDXDialog;
import com.takyon.gamelib.GDXGameNet;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.GDXText;
import com.takyon.gamelib.GDXTextButton;
import com.takyon.gamelib.Language;
import com.takyon.gamelib.network.Client;
import java.io.IOException;

public class BattleScreenIntro
extends BattleGameScreen {
    public static GDXImage imgBackground;
    private GDXTextButton btnCpu;
    private GDXTextButton btnLocal;
    private GDXTextButton btnReseau;
    private GDXTextButton btnOptions;
    private GDXTextButton btnModeDuel;
    private GDXTextButton btnBattle;
    private GDXDialog quitDialog;

    @Override
    public void firstInit() {
        super.firstInit();
        this.btnCpu = new GDXTextButton(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/void", true, false, true);
        this.btnCpu.label = new GDXText(Fonts.BUTTON, Language.tr("menu.cpu"));
        this.btnCpu.setPosition(300.0f, 500.0f);
        this.btnLocal = new GDXTextButton(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/void", true, false, false);
        this.btnLocal.label = new GDXText(Fonts.BUTTON, Language.tr("menu.local"));
        this.btnLocal.setPosition(300.0f, 700.0f);
        this.btnReseau = new GDXTextButton(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/void", true, false, true);
        this.btnReseau.label = new GDXText(Fonts.BUTTON, Language.tr("menu.network"));
        this.btnReseau.setPosition(300.0f, 900.0f);
        this.btnReseau.setEnabled(false);
        this.btnOptions = new GDXTextButton(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/void", true, false, true);
        this.btnOptions.label = new GDXText(Fonts.BUTTON, Language.tr("menu.options"));
        this.btnOptions.setPosition(300.0f, 1100.0f);
        this.btnOptions.setEnabled(false);
        this.btnModeDuel = new GDXTextButton(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/void", true, false, false);
        this.btnBattle = new GDXTextButton(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/void", true, false, false);
        imgBackground = new GDXImage(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/menu_intro.png");
        this.quitDialog = new GDXDialog(){

            @Override
            public void onYes() {
                System.exit(0);
            }
        };
    }

    @Override
    public void init() {
    }

    @Override
    public void finish() {
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        this.quitDialog.show(Language.tr("quit.all"), Language.tr(""));
    }

    @Override
    public void onTouched(int x, int y, int pointer, int button) {
        if (this.quitDialog.isVisible()) {
            this.quitDialog.onTouchDown(x, y);
        } else if (this.btnCpu.isClicked(x, y)) {
            BattleScreenIntro.changeScreen(screenGame);
            BattleGame.isNetwork = false;
            BattleGame.isIA = true;
            new BattleIA();
        } else if (this.btnLocal.isClicked(x, y)) {
            BattleScreenIntro.changeScreen(screenGame);
            BattleGame.isIA = false;
            BattleGame.isNetwork = false;
        } else if (this.btnReseau.isClicked(x, y)) {
            this.tryToConenct();
        } else if (this.btnOptions.isClicked(x, y)) {
            BattleScreenIntro.changeScreen(screenOptions);
        }
    }

    private void tryToConenct() {
        try {
            GDXGameNet.clientToServer = new Client(GDXGameNet.ipServer, GDXGameNet.portServer);
            GDXGameNet.clientToServer.start();
            BattleScreenIntro.changeScreen(screenParties);
            BattleGame.isNetwork = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void display() {
        GDXImage.batch.begin();
        imgBackground.draw();
        super.display();
        this.btnCpu.draw();
        this.btnLocal.draw();
        this.btnReseau.draw();
        this.btnOptions.draw();
        this.quitDialog.display();
        GDXImage.batch.end();
    }
}

