/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battleship;

import com.takyon.battleship.BattleMain;
import com.takyon.battleship.Cell;
import com.takyon.battleship.Part;
import com.takyon.battleship.Ship;
import java.util.ArrayList;

public class Grid {
    public float posX;
    public float posY;
    public float size;
    public int nbCols;
    public int nbRows;
    public Cell[][] cells;
    public ArrayList<Ship> ships;

    public Grid() {
    }

    public Grid(int nbCols, int nbRows, ArrayList<Ship> ships) {
        this.nbCols = nbCols;
        this.nbRows = nbRows;
        this.cells = new Cell[nbCols][nbRows];
        this.ships = ships;
    }

    public void onAttack(int i, int j) {
        Cell cell = this.getCell(i, j);
        if (cell.value == 0) {
            int k = 0;
            while (k < this.ships.size()) {
                Part part;
                Ship ship = this.ships.get(k);
                if (!ship.isDestroyed && (part = ship.getPart(i, j)) != null) {
                    part.touch();
                    if (ship.isDestroyed() && this.checkAllDestroyed()) {
                        BattleMain.setWinner();
                    }
                    cell.value = 1;
                }
                ++k;
            }
        }
    }

    private boolean checkAllDestroyed() {
        int k = 0;
        while (k < this.ships.size()) {
            Ship ship = this.ships.get(k);
            if (!ship.isDestroyed) {
                return false;
            }
            ++k;
        }
        return true;
    }

    private Cell getCell(int i, int j) {
        if (i >= 0 && i < this.nbCols && j >= 0 && j < this.nbRows) {
            return this.cells[i][j];
        }
        return null;
    }

    public void drawShip(Ship ship) {
        int c = 0;
        while (c < ship.parts.length) {
            Part part = ship.parts[c];
            ++c;
        }
    }

    public void draw() {
        int k = 0;
        while (k < this.ships.size()) {
            Ship ship = this.ships.get(k);
            if (!ship.isDestroyed) {
                this.drawShip(ship);
            }
            ++k;
        }
    }
}

