/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.game;

import com.badlogic.gdx.graphics.Texture;
import com.takyon.chess.game.Cell;
import com.takyon.chess.game.ia.GridState;
import com.takyon.chess.pions.Pion;
import com.takyon.chess.pions.PionFactory;
import com.takyon.chess.utils.Positions;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Scene2D;

public class Grid {
    public int rows;
    public int cols;
    protected Pion[][] pions;

    protected Grid() {
    }

    public Grid(int cols, int rows) {
        this();
        this.pions = new Pion[cols][rows];
        this.cols = cols;
        this.rows = rows;
        Cell.initCells(cols, rows);
    }

    public Pion getPion(int i, int j) {
        if (i < 0 || i > this.cols - 1 || j < 0 || j > this.rows - 1) {
            return null;
        }
        return this.pions[i][j];
    }

    public void setPion(int i, int j, Pion pion) {
        if (i < 0 || i > this.cols - 1 || j < 0 || j > this.rows - 1) {
            return;
        }
        if (pion != null) {
            pion.setCoords(i, j);
        }
        this.pions[i][j] = pion;
    }

    public void init() {
        Positions.gridSize = 1024.0f / (float)Math.max(this.cols, this.rows);
        Graphics.ratio = Positions.gridSize / 128.0f;
    }

    public void drawCase(Texture tex, int i, int j) {
        GDXImage.draw(tex, (Positions.gridPos.x + (float)i * Positions.gridSize) * Scene2D.RATIO, ((float)Scene2D.SCREEN_HEIGHT_BASE - ((float)j * Positions.gridSize + Positions.gridPos.y + Positions.gridSize)) * Scene2D.RATIO, Positions.gridSize * Scene2D.RATIO, Positions.gridSize * Scene2D.RATIO, 1.0f);
    }

    public void draw() {
        int i = 0;
        while (i < this.cols) {
            int j = 0;
            while (j < this.rows) {
                Pion pion = this.getPion(i, j);
                if (pion != null) {
                    pion.draw();
                }
                ++j;
            }
            ++i;
        }
    }

    public void reset() {
        int i = 0;
        while (i < this.cols) {
            int j = 0;
            while (j < this.rows) {
                this.pions[i][j] = null;
                ++j;
            }
            ++i;
        }
    }

    public GridState getState() {
        GridState gridState = new GridState(this.cols, this.rows);
        int i = 0;
        while (i < this.cols) {
            int j = 0;
            while (j < this.rows) {
                Pion pion = this.pions[i][j];
                if (pion != null) {
                    gridState.pions[i][j] = PionFactory.createPionFrom(pion.player, pion);
                    gridState.pions[i][j].grid = gridState;
                }
                ++j;
            }
            ++i;
        }
        return gridState;
    }
}

