/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.game;

import com.badlogic.gdx.utils.Array;
import com.takyon.chess.game.PlayerColor;
import com.takyon.chess.game.rules.OptionsPlayer;
import com.takyon.chess.pions.Pion;
import com.takyon.gamelib.GDXImage;

public class Player {
    public PlayerColor color;
    public Directions directions;
    public int nbRois;
    public int nbEau;
    public int nbFeu;
    public int nbAirs;
    public int nbEggs;
    public int nbPions;
    public int nbCoupsJoues;
    public int nbCoupsJouesMemePion;
    public int nbJokers;
    public Array<Pion> pions;
    public Array<Pion> pionsPris;
    public int nbRoiPris;
    public int nbAirPris;
    public int nbFeuPris;
    public int nbEauPris;
    public int nbOeufPris;
    public int nbOeufsameneAuBord;
    public boolean hasFinishedPlacing;
    public int nbOeufRemplis;
    public transient GDXImage imageFond;
    public int bordY;
    public OptionsPlayer optionsPlayer;
    public boolean canSeeJokers;
    public boolean canPass;
    public boolean mustNotChangeTurn;
    public Pion lastPionMoved;

    public Player() {
    }

    public Player(PlayerColor color) {
        this.color = color;
        this.pions = new Array();
        this.pionsPris = new Array();
        this.optionsPlayer = new OptionsPlayer();
    }

    public void init() {
        this.setDirections(Directions.LIGNES_COLONNES);
        this.reset();
    }

    public void copyFrom(Player player) {
        this.color = player.color;
        this.nbRois = player.nbRois;
        this.nbEau = player.nbEau;
        this.nbFeu = player.nbFeu;
        this.nbAirs = player.nbAirs;
        this.nbEggs = player.nbEggs;
        this.nbJokers = player.nbJokers;
        this.nbRoiPris = player.nbRoiPris;
        this.nbAirPris = player.nbAirPris;
        this.nbFeuPris = player.nbFeuPris;
        this.nbEauPris = player.nbEauPris;
        this.nbOeufPris = player.nbOeufPris;
        this.nbOeufRemplis = player.nbOeufRemplis;
    }

    public PlayerColor getColor() {
        return this.color;
    }

    public void setColor(PlayerColor color) {
        this.color = color;
    }

    public Directions getDirections() {
        return this.directions;
    }

    public void setDirections(Directions direction) {
        this.directions = direction;
    }

    public boolean hasFinishedPlacing() {
        return this.hasFinishedPlacing;
    }

    public void gagneJoker(int n) {
        this.nbJokers += n;
        if (this.nbJokers > this.optionsPlayer.nbJokersMax.value) {
            this.nbJokers = this.optionsPlayer.nbJokersMax.value;
        }
    }

    public void perdJoker(int n) {
        this.nbJokers -= n;
        if (this.nbJokers < 0) {
            this.nbJokers = 0;
        }
    }

    public void changeTurn() {
        this.canPass = true;
    }

    public boolean canPass() {
        return this.canPass;
    }

    public void pass() {
        this.canPass = false;
    }

    public String toString() {
        return "" + (Object)((Object)this.color);
    }

    public void changeDirections() {
        if (this.directions == Directions.DIAGONALES) {
            this.directions = Directions.LIGNES_COLONNES;
        } else if (this.directions == Directions.LIGNES_COLONNES) {
            this.directions = Directions.DIAGONALES;
        }
    }

    public int getNbPionsPris() {
        return this.nbRoiPris + this.nbAirPris + this.nbFeuPris + this.nbEauPris + this.nbOeufPris;
    }

    public void reset() {
        this.nbRois = 2;
        this.nbEau = 2;
        this.nbFeu = 2;
        this.nbAirs = 2;
        this.nbEggs = 8;
        this.nbPions = 48;
        this.nbJokers = this.optionsPlayer.nbJokersMax.value;
        this.nbCoupsJoues = 0;
        this.nbCoupsJouesMemePion = 0;
        this.nbRoiPris = 0;
        this.nbAirPris = 0;
        this.nbFeuPris = 0;
        this.nbEauPris = 0;
        this.nbOeufPris = 0;
        this.nbOeufsameneAuBord = 0;
        this.nbOeufRemplis = 0;
        this.hasFinishedPlacing = false;
        this.canSeeJokers = false;
        this.canPass = true;
        this.mustNotChangeTurn = false;
    }

    public static enum Directions {
        LIGNES_COLONNES,
        DIAGONALES;

    }
}

