/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.game.rules;

import com.badlogic.gdx.utils.Array;
import com.takyon.chess.game.ChessGame;
import com.takyon.chess.game.Coup;
import com.takyon.chess.game.Grid;
import com.takyon.chess.game.Player;
import com.takyon.chess.game.PlayerColor;
import com.takyon.chess.game.exceptions.CaseOccupeException;
import com.takyon.chess.game.rules.GameParamaterInt;
import com.takyon.chess.game.rules.OptionsPlayer;
import com.takyon.chess.network.messages.game.CoupMessage;
import com.takyon.chess.network.messages.game.PassMessage;
import com.takyon.chess.pions.Oeuf;
import com.takyon.chess.pions.Pion;
import com.takyon.chess.pions.PionFactory;
import com.takyon.chess.screens.ScreenGame;
import com.takyon.chess.utils.BattleGraphics;
import com.takyon.chess.utils.Positions;
import com.takyon.gamelib.AbstractMessage;
import com.takyon.gamelib.GDXGame;
import com.takyon.gamelib.GDXGameNet;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.Language;

public class GameRules {
    public static final int NB_JOKERS_BOUSSOLE = 1;
    public static final int NB_JOKERS_MAX = 12;
    public static Pion.Type currentType;
    public static Player currentPlayer;
    public static Grid grid;
    public static Pion selectedPion;
    public static Oeuf lastPion;
    public static GameParamaterInt optionNbColumnsGrid;
    public static GameParamaterInt optionNbRowsGrid;
    public static OptionsPlayer optionsRed;
    public static OptionsPlayer optionsBlue;
    public static Array<AbstractMessage> historiqueActions;

    public GameRules() {
        optionNbColumnsGrid = new GameParamaterInt(12);
        optionNbRowsGrid = new GameParamaterInt(12);
        optionsRed = new OptionsPlayer();
        optionsBlue = new OptionsPlayer();
    }

    public void init() {
        grid = new Grid(GameRules.optionNbColumnsGrid.value, GameRules.optionNbRowsGrid.value);
        grid.init();
        if (GameRules.grid.cols > GameRules.grid.rows) {
            Positions.gridPos.y = 28.0f + (1024.0f - Positions.gridSize * (float)GameRules.grid.rows) / 2.0f;
        } else if (GameRules.grid.cols < GameRules.grid.rows) {
            Positions.gridPos.x = 448.0f + (1024.0f - Positions.gridSize * (float)GameRules.grid.cols) / 2.0f;
        }
        BattleGraphics.initGridTex();
        ChessGame.playerRed = new Player(PlayerColor.BLACK);
        ChessGame.playerRed.imageFond = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/fond_pion_black.png");
        ChessGame.playerRed.bordY = GameRules.grid.rows - 1;
        ChessGame.playerRed.optionsPlayer = optionsRed;
        ChessGame.playerRed.init();
        ChessGame.playerBlue = new Player(PlayerColor.WHITE);
        ChessGame.playerBlue.imageFond = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/fond_pion_white.png");
        ChessGame.playerBlue.bordY = 0;
        ChessGame.playerBlue.optionsPlayer = optionsBlue;
        ChessGame.playerBlue.init();
        currentPlayer = ChessGame.playerBlue;
    }

    public static void reset() {
        grid.reset();
        ChessGame.playerBlue.reset();
        ChessGame.playerRed.reset();
    }

    public static boolean isVide(int i, int j) {
        return grid.getPion(i, j) == null;
    }

    public static void deletePion(int i, int j) {
        Pion pion = grid.getPion(i, j);
        if (pion != null) {
            grid.setPion(i, j, null);
            pion.player.pions.removeValue((Object)pion, true);
            ++pion.player.nbPions;
        }
    }

    public static void placePion(int i, int j) {
        if (GameRules.isVide(i, j)) {
            boolean isWellPlaced = false;
            if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
                if (j == GameRules.grid.rows - 3 || j == GameRules.grid.rows - 2 || j == GameRules.grid.rows - 1) {
                    isWellPlaced = true;
                }
            } else if (GameRules.currentPlayer.color == PlayerColor.BLACK && (j == 0 || j == 1 || j == 2)) {
                isWellPlaced = true;
            }
            if (ChessGame.isDebug) {
                isWellPlaced = true;
            }
            if (isWellPlaced) {
                boolean canPlacePion = false;
                if (ChessGame.isDebug) {
                    if (GameRules.currentPlayer.nbPions > 0) {
                        canPlacePion = true;
                        --GameRules.currentPlayer.nbPions;
                    } else {
                        ScreenGame.textMessage.setText(Language.tr("message_max_unites"));
                        ScreenGame.isMessageAlert = true;
                    }
                } else if (currentType == Pion.Type.OEUF) {
                    if (GameRules.currentPlayer.nbEggs > 0) {
                        canPlacePion = true;
                        --GameRules.currentPlayer.nbEggs;
                    }
                } else if (currentType == Pion.Type.AIR) {
                    if (GameRules.currentPlayer.nbAirs > 0) {
                        canPlacePion = true;
                        --GameRules.currentPlayer.nbAirs;
                    }
                } else if (currentType == Pion.Type.FEU) {
                    if (GameRules.currentPlayer.nbFeu > 0) {
                        canPlacePion = true;
                        --GameRules.currentPlayer.nbFeu;
                    }
                } else if (currentType == Pion.Type.EAU) {
                    if (GameRules.currentPlayer.nbEau > 0) {
                        canPlacePion = true;
                        --GameRules.currentPlayer.nbEau;
                    }
                } else if (currentType == Pion.Type.ROI && GameRules.currentPlayer.nbRois > 0) {
                    canPlacePion = true;
                    --GameRules.currentPlayer.nbRois;
                }
                if (canPlacePion) {
                    Pion newPion = PionFactory.createPion(currentPlayer, currentType);
                    grid.setPion(i, j, newPion);
                    GameRules.currentPlayer.pions.add((Object)newPion);
                }
            }
        } else if (GameRules.grid.getPion((int)i, (int)j).type == Pion.Type.OEUF) {
            Oeuf oeuf = (Oeuf)grid.getPion(i, j);
            if (oeuf.content == null && currentType != Pion.Type.ROI && currentType != Pion.Type.OEUF && GameRules.currentPlayer.nbOeufRemplis < GameRules.currentPlayer.optionsPlayer.nbOeufsRemplisMax.value) {
                oeuf.content = currentType;
                ++GameRules.currentPlayer.nbOeufRemplis;
            }
        }
    }

    public static void moveTo(Pion pion, int i, int j) {
        if (pion == GameRules.currentPlayer.lastPionMoved) {
            if (GameRules.currentPlayer.nbCoupsJouesMemePion + 1 > 4) {
                ScreenGame.isMessageAlert = true;
                ScreenGame.textMessage.setText(Language.tr("message_plus_de_quatre_move"));
                return;
            }
            ++GameRules.currentPlayer.nbCoupsJouesMemePion;
        } else {
            GameRules.currentPlayer.nbCoupsJouesMemePion = 1;
        }
        GameRules.currentPlayer.lastPionMoved = pion;
        if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
            ScreenGame.updateMovementIconsWhite(pion.i, pion.j, i, j);
        } else if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
            ScreenGame.updateMovementIconsBlack(pion.i, pion.j, i, j);
        }
        try {
            pion.moveTo(i, j);
        }
        catch (CaseOccupeException e) {
            e.printStackTrace();
            ChessGame.saveBug();
        }
        if (ChessGame.isNetwork) {
            GDXGameNet.clientToOpponent.sendMessage(new CoupMessage(pion.i, pion.j, i, j));
        }
        if (!pion.player.mustNotChangeTurn) {
            ScreenGame.changeTurn();
        }
    }

    public static void pass() {
        currentPlayer.pass();
        currentPlayer.gagneJoker(2);
        selectedPion = null;
        ScreenGame.changeTurnPass();
        if (ChessGame.isNetwork) {
            GDXGameNet.clientToOpponent.sendMessage(new PassMessage(currentPlayer));
        }
    }

    public static void changeTurnPass() {
        GameRules.changeTurn();
    }

    public static void changeTurnPlayer() {
        currentPlayer.changeTurn();
        GameRules.changeTurn();
    }

    private static void changeTurn() {
        GameRules.currentPlayer.canSeeJokers = false;
        if (selectedPion != null) {
            GameRules.selectedPion.cellsVoid.clear();
            selectedPion = null;
        }
        if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
            currentPlayer = ChessGame.playerRed;
        } else if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
            currentPlayer = ChessGame.playerBlue;
        }
    }

    public static void checkFinPartieTambours() {
        int nbTambour1 = 0;
        for (Pion pion : ChessGame.playerBlue.pions) {
            if (pion.type != Pion.Type.OEUF) continue;
            ++nbTambour1;
        }
        int nbTambour2 = 0;
        for (Pion pion : ChessGame.playerRed.pions) {
            if (pion.type != Pion.Type.OEUF) continue;
            ++nbTambour2;
        }
        if (nbTambour1 == 0 && nbTambour2 == 0) {
            int score1 = 0;
            for (Pion pion : ChessGame.playerBlue.pions) {
                if (pion.type == Pion.Type.ROI) {
                    score1 += 2;
                    continue;
                }
                ++score1;
            }
            int score2 = 0;
            for (Pion pion : ChessGame.playerRed.pions) {
                if (pion.type == Pion.Type.ROI) {
                    score2 += 2;
                    continue;
                }
                ++score2;
            }
            if (score1 > score2) {
                GameRules.onEndGame(ChessGame.playerBlue);
            } else if (score1 < score2) {
                GameRules.onEndGame(ChessGame.playerRed);
            } else {
                GameRules.onEndGame(null);
            }
        }
    }

    public static void playIA() {
        Coup coup = ChessGame.ia.play();
        if (coup == null) {
            GameRules.pass();
        } else {
            GameRules.play(coup);
        }
    }

    public static void changeBoussole(Player player1, Player player2) {
        if (player1.nbJokers > 0) {
            if (!ScreenGame.isPlacing) {
                player1.perdJoker(1);
                ScreenGame.changeTurn();
            }
            player2.changeDirections();
            ScreenGame.updateDirections();
        }
    }

    public static void onEat(Pion pion, Pion ennemy) {
        Player player = pion.player;
        if (player.optionsPlayer.isGainPerteJoker.value) {
            player.gagneJoker(player.optionsPlayer.nbGainPerteJoker.value);
        }
        player.pionsPris.add((Object)ennemy);
        Player opponent = ennemy.player;
        if (opponent.optionsPlayer.isGainPerteJoker.value) {
            opponent.perdJoker(opponent.optionsPlayer.nbGainPerteJoker.value);
        }
        ennemy.player.pions.removeValue((Object)ennemy, true);
        ennemy.onEatenBy(player);
        if (player.nbRoiPris == player.optionsPlayer.nbRoisAPrendre.value || player.getNbPionsPris() == player.optionsPlayer.nbPionsAPrendre.value) {
            GameRules.onEndGame(player);
        }
    }

    public static void onEndGame(Player player) {
        ScreenGame.isEnd = true;
        if (player == null) {
            ScreenGame.imageWin = ScreenGame.imageWinNull;
        } else if (player.color == PlayerColor.BLACK) {
            ScreenGame.imageWin = ScreenGame.imageWinRed;
        } else if (player.color == PlayerColor.WHITE) {
            ScreenGame.imageWin = ScreenGame.imageWinBlue;
        }
    }

    public static boolean isInGrid(int i, int j) {
        return i >= 0 && i < GameRules.grid.cols && j >= 0 && j < GameRules.grid.rows;
    }

    public static void initTurn(Player player) {
        if (selectedPion != null) {
            GameRules.selectedPion.cellsVoid.clear();
            selectedPion = null;
        }
        currentPlayer = player;
    }

    public static void play(int i, int j) {
        if (selectedPion.canMoveTo(i, j)) {
            historiqueActions.add((Object)new CoupMessage(GameRules.selectedPion.i, GameRules.selectedPion.j, i, j));
            GameRules.moveTo(selectedPion, i, j);
        }
    }

    public static void play(Coup coup) {
        if (coup.pion.canMoveTo(coup.dest.i, coup.dest.j)) {
            historiqueActions.add((Object)new CoupMessage(coup.pion.i, coup.pion.j, coup.dest.i, coup.dest.j));
            GameRules.moveTo(coup.pion, coup.dest.i, coup.dest.j);
        }
    }

    public static void recupPion(Pion.Type type) {
        Pion pion = PionFactory.createPion(GameRules.lastPion.player, type);
        GameRules.lastPion.player.pions.add((Object)pion);
        grid.setPion(pion.i, pion.j, pion);
    }

    public static void seeJokers() {
        currentPlayer.perdJoker(1);
        GameRules.currentPlayer.canSeeJokers = true;
    }
}

