/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.pions;

import com.badlogic.gdx.utils.Array;
import com.takyon.chess.game.Cell;
import com.takyon.chess.game.Player;
import com.takyon.chess.pions.Pion;

public class Eau
extends Pion {
    public Eau() {
    }

    public Eau(Player player, Pion.Type type) {
        super(player, type);
    }

    @Override
    public void setAvailableCells() {
        if (this.player.directions == Player.Directions.LIGNES_COLONNES) {
            if (this.player.optionsPlayer.moveArtillerie.value >= 2) {
                this.cellsVoid.addAll(this.getAvailableCellsLignesColonnes(this.i, this.j, 2));
                if (this.player.nbJokers > 0 && this.player.optionsPlayer.moveArtillerie.value == 3) {
                    this.cellsJoker.addAll(this.getAvailableCellsLignesColonnes(this.i, this.j, 3));
                }
            }
            this.cellsVoid.addAll(this.getAvailableCellsDiagonale(this.i, this.j, 1));
        } else if (this.player.directions == Player.Directions.DIAGONALES) {
            if (this.player.optionsPlayer.moveArtillerie.value >= 2) {
                this.cellsVoid.addAll(this.getAvailableCellsDiagonale(this.i, this.j, 2));
                if (this.player.nbJokers > 0 && this.player.optionsPlayer.moveArtillerie.value == 3) {
                    this.cellsJoker.addAll(this.getAvailableCellsDiagonale(this.i, this.j, 3));
                }
            }
            this.cellsVoid.addAll(this.getAvailableCellsLignesColonnes(this.i, this.j, 1));
        }
        for (Cell cell : this.cellsVoid) {
            this.cellsJoker.removeValue((Object)cell, true);
        }
    }

    @Override
    public void setAvailableCellsSuper() {
        super.setAvailableCellsSuper();
        if (this.player.optionsPlayer.isArtillleriePrendTout.value) {
            this.checkPriseCourteDistance(this.i, this.j - 1);
            this.checkPriseCourteDistance(this.i + 1, this.j - 1);
            this.checkPriseCourteDistance(this.i + 1, this.j);
            this.checkPriseCourteDistance(this.i + 1, this.j + 1);
            this.checkPriseCourteDistance(this.i, this.j + 1);
            this.checkPriseCourteDistance(this.i - 1, this.j + 1);
            this.checkPriseCourteDistance(this.i - 1, this.j);
            this.checkPriseCourteDistance(this.i - 1, this.j - 1);
        }
    }

    private void checkPriseCourteDistance(int i, int j) {
        Pion pion = this.grid.getPion(i, j);
        if (pion != null && !this.canTake(pion)) {
            this.addCell((Array<Cell>)this.cellsVoid, Cell.get(i, j));
        }
    }

    @Override
    public boolean canTake(Pion pion) {
        if (pion.type == Pion.Type.AIR || pion.type == Pion.Type.EAU) {
            return false;
        }
        return pion.canBeTakenBy(this);
    }

    @Override
    public void onEatenBy(Player opponnent) {
        super.onEatenBy(opponnent);
        ++opponnent.nbEauPris;
    }

    @Override
    public int getValue() {
        return 3;
    }
}

