/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.pions;

import com.badlogic.gdx.utils.Array;
import com.takyon.chess.game.Cell;
import com.takyon.chess.game.Player;
import com.takyon.chess.pions.Pion;

public class Feu
extends Pion {
    private boolean pionRencontre = false;
    private boolean pionCavalerieRencontre = false;
    private boolean deuxPionAdjRencontre = false;

    public Feu() {
    }

    public Feu(Player player, Pion.Type type) {
        super(player, type);
    }

    @Override
    public boolean canAddCell(int di, int dj) {
        if (!this.player.optionsPlayer.canCavaleriePassCavalerie.value && this.pionCavalerieRencontre) {
            return false;
        }
        if (!this.player.optionsPlayer.canCavaleriePassTwoPions.value && this.deuxPionAdjRencontre) {
            return false;
        }
        if (this.pionRencontre) {
            if (this.player.nbJokers > 0) {
                this.addCell(Cell.get(di, dj), (Array<Cell>)this.cellsJoker);
            }
        } else {
            this.addCell(Cell.get(di, dj), (Array<Cell>)this.cellsVoid);
        }
        return true;
    }

    private void resetBooleans() {
        this.pionCavalerieRencontre = false;
        this.pionRencontre = false;
        this.deuxPionAdjRencontre = false;
    }

    @Override
    public void setAvailableCells() {
        block9: {
            block10: {
                if (this.player.directions != Player.Directions.DIAGONALES) break block10;
                int di = this.i + 1;
                int dj = this.j + 1;
                this.resetBooleans();
                while (di < this.grid.cols && dj < this.grid.rows && this.canAddCell(di, dj)) {
                    this.checkRules(di, dj, di + 1, dj + 1);
                    ++di;
                    ++dj;
                }
                di = this.i - 1;
                dj = this.j + 1;
                this.resetBooleans();
                while (di >= 0 && dj < this.grid.rows && this.canAddCell(di, dj)) {
                    this.checkRules(di, dj, di - 1, dj + 1);
                    --di;
                    ++dj;
                }
                di = this.i - 1;
                dj = this.j - 1;
                this.resetBooleans();
                while (di >= 0 && dj >= 0 && this.canAddCell(di, dj)) {
                    this.checkRules(di, dj, di - 1, dj - 1);
                    --di;
                    --dj;
                }
                di = this.i + 1;
                dj = this.j - 1;
                this.resetBooleans();
                while (di < this.grid.cols && dj >= 0 && this.canAddCell(di, dj)) {
                    this.checkRules(di, dj, di + 1, dj - 1);
                    ++di;
                    --dj;
                }
                break block9;
            }
            if (this.player.directions != Player.Directions.LIGNES_COLONNES) break block9;
            this.resetBooleans();
            int r = this.j + 1;
            while (r < this.grid.rows) {
                if (!this.canAddCell(this.i, r)) break;
                this.checkRules(this.i, r, this.i, r + 1);
                ++r;
            }
            this.resetBooleans();
            r = this.j - 1;
            while (r >= 0) {
                if (!this.canAddCell(this.i, r)) break;
                this.checkRules(this.i, r, this.i, r - 1);
                --r;
            }
            this.resetBooleans();
            int c = this.i + 1;
            while (c < this.grid.cols) {
                if (!this.canAddCell(c, this.j)) break;
                this.checkRules(c, this.j, c + 1, this.j);
                ++c;
            }
            this.resetBooleans();
            c = this.i - 1;
            while (c >= 0) {
                if (this.canAddCell(c, this.j)) {
                    this.checkRules(c, this.j, c - 1, this.j);
                    --c;
                    continue;
                }
                break;
            }
        }
    }

    private void checkRules(int di, int dj, int di2, int dj2) {
        Pion pion1 = this.grid.getPion(di, dj);
        Pion pion2 = this.grid.getPion(di2, dj2);
        if (pion1 != null && pion1.type == Pion.Type.FEU && this.isEnnemy(di, dj)) {
            this.pionCavalerieRencontre = true;
        }
        if (pion1 != null) {
            this.pionRencontre = true;
        }
        if (pion1 != null && pion2 != null) {
            this.deuxPionAdjRencontre = true;
        }
    }

    @Override
    public boolean canTake(Pion pion) {
        if (pion.type == Pion.Type.EAU || pion.type == Pion.Type.FEU) {
            return false;
        }
        return pion.canBeTakenBy(this);
    }

    @Override
    public void onEatenBy(Player opponnent) {
        super.onEatenBy(opponnent);
        ++opponnent.nbFeuPris;
    }

    @Override
    public int getValue() {
        return 4;
    }
}

