/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.pions;

import com.badlogic.gdx.utils.Array;
import com.takyon.chess.game.Cell;
import com.takyon.chess.game.Player;
import com.takyon.chess.game.exceptions.CaseOccupeException;
import com.takyon.chess.game.rules.GameRules;
import com.takyon.chess.pions.Pion;
import com.takyon.chess.pions.PionFactory;
import com.takyon.chess.screens.ScreenGame;
import com.takyon.chess.utils.Positions;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.Position;

public class Oeuf
extends Pion {
    public Pion.Type content;

    public Oeuf() {
    }

    public Oeuf(Player player, Pion.Type type) {
        super(player, type);
    }

    public Pion.Type getContent() {
        return this.content;
    }

    public void setContent(Pion.Type content) {
        this.content = content;
    }

    @Override
    public void setAvailableCells() {
        if (this.hasEscort()) {
            this.addCell(Cell.get(this.i + 1, this.j), (Array<Cell>)this.cellsVoid);
            this.addCell(Cell.get(this.i - 1, this.j), (Array<Cell>)this.cellsVoid);
            this.addCell(Cell.get(this.i, this.j - 1), (Array<Cell>)this.cellsVoid);
            this.addCell(Cell.get(this.i, this.j + 1), (Array<Cell>)this.cellsVoid);
        }
        if (this.content != null && this.player.nbJokers > 0) {
            this.cellsJoker.add((Object)Cell.get(this.i, this.j));
        }
    }

    @Override
    public boolean canTake(Pion pion) {
        return false;
    }

    @Override
    public int getValue() {
        if (this.content != null) {
            return 1 + PionFactory.createPion(this.player, this.content).getValue();
        }
        return 1;
    }

    public boolean hasEscort() {
        return this.isAllie(this.i + 1, this.j) || this.isAllie(this.i - 1, this.j) || this.isAllie(this.i, this.j - 1) || this.isAllie(this.i, this.j + 1);
    }

    @Override
    public void moveTo(int i, int j) {
        try {
            if (j == this.player.bordY) {
                super.moveTo(i, j);
                ++this.player.nbOeufsameneAuBord;
                if (this.player.nbOeufsameneAuBord == this.player.optionsPlayer.nbOeufsAamenerAuBord.value) {
                    GameRules.onEndGame(this.player);
                    ScreenGame.isRecupPion = false;
                    return;
                }
                ScreenGame.isRecupPion = true;
                GameRules.lastPion = this;
            } else if (this.i == i && this.j == j) {
                this.eclore();
            } else {
                super.moveTo(i, j);
                this.player.gagneJoker(1);
            }
        }
        catch (CaseOccupeException e) {
            e.printStackTrace();
        }
    }

    private void eclore() {
        if (this.player.nbJokers > this.player.optionsPlayer.nbJokersEclosion.value) {
            Pion newPion = PionFactory.createPion(this.player, this.content);
            this.player.pions.removeValue((Object)this, true);
            this.grid.setPion(this.i, this.j, newPion);
            this.player.pions.add((Object)newPion);
            this.player.perdJoker(this.player.optionsPlayer.nbJokersEclosion.value);
            if (this.player.optionsPlayer.canPlayAfterEclosion.value) {
                this.player.mustNotChangeTurn = true;
            }
            ScreenGame.select(newPion);
        }
    }

    @Override
    public void onEatenBy(Player opponnent) {
        super.onEatenBy(opponnent);
        ++opponnent.nbOeufPris;
    }

    @Override
    public void draw() {
        if (this.isVisible()) {
            Position position = this.getPositionScale();
            this.player.imageFond.draw(position.x, position.y, Positions.gridSize, Positions.gridSize);
            if ((ScreenGame.isPlacing || this.player.canSeeJokers) && this.content != null) {
                GDXImage imageContent = PionFactory.imagesPionsBlue[this.content.ordinal()];
                imageContent.setAlpha(0.7f);
                imageContent.draw(position.x, position.y, Positions.gridSize, Positions.gridSize);
            }
            this.image.draw(position.x, position.y, Positions.gridSize, Positions.gridSize);
        }
    }
}

