/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.screens;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.takyon.chess.screens.ScreenGame;
import com.takyon.chess.screens.ScreenIntro;
import com.takyon.chess.screens.ScreenOptions;
import com.takyon.chess.screens.ScreenParties;
import com.takyon.chess.utils.Fonts;
import com.takyon.chess.utils.Positions;
import com.takyon.gamelib.GDXButton;
import com.takyon.gamelib.GDXGame;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.GDXText;
import com.takyon.gamelib.GameScreen;

public abstract class ChessGameScreen
extends GameScreen {
    private static long time = 0L;
    public static Sound sfx_back;
    public static Sound sfx_select;
    public static ScreenIntro screenIntro;
    public static ScreenGame screenGame;
    public static ScreenOptions screenOptions;
    public static ScreenParties screenParties;
    private boolean isTouched;
    public static GDXButton btnOk;
    public static GDXButton btnYes;
    public static GDXButton btnNo;
    public static GDXButton btnCancel;
    public static GDXImage imageDialogConfirm;
    public static GDXText textMessage;
    public static GDXText textInput;
    public static boolean isMessageAlert;

    static {
        isMessageAlert = false;
    }

    @Override
    public void firstInit() {
        imageDialogConfirm = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/dialog.png");
        imageDialogConfirm.setPosition(500.0f, 400.0f);
        btnOk = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/ok", true, false, false);
        btnOk.setPosition(ChessGameScreen.imageDialogConfirm.getPosition().x + 250.0f, ChessGameScreen.imageDialogConfirm.getPosition().y + 350.0f);
        btnYes = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/yes", true, false, false);
        btnYes.setPosition(ChessGameScreen.imageDialogConfirm.getPosition().x + 50.0f, ChessGameScreen.imageDialogConfirm.getPosition().y + 350.0f);
        btnNo = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/no", true, false, false);
        btnNo.setPosition(ChessGameScreen.imageDialogConfirm.getPosition().x + 450.0f, ChessGameScreen.imageDialogConfirm.getPosition().y + 350.0f);
        btnCancel = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/annuler", true, false, false);
        btnCancel.setPosition(ChessGameScreen.imageDialogConfirm.getPosition().x + 450.0f, ChessGameScreen.imageDialogConfirm.getPosition().y + 350.0f);
        textMessage = new GDXText(Fonts.TEXT, "");
        textMessage.setPosition(ChessGameScreen.imageDialogConfirm.getPosition().x + 50.0f, ChessGameScreen.imageDialogConfirm.getPosition().y + 150.0f);
        textInput = new GDXText(Fonts.TEXT, "");
        textInput.setPosition(ChessGameScreen.imageDialogConfirm.getPosition().x + 50.0f, ChessGameScreen.imageDialogConfirm.getPosition().y + 250.0f);
    }

    public static void initScreens() {
        screenIntro = new ScreenIntro();
        screenGame = new ScreenGame();
        screenOptions = new ScreenOptions();
        screenParties = new ScreenParties();
    }

    @Override
    public void display() {
    }

    @Override
    public void process(float dt) {
        if (Gdx.app.getType() != Application.ApplicationType.Android) {
            Gdx.input.isKeyJustPressed(40);
            if (Gdx.input.isKeyJustPressed(131)) {
                this.onBackPressed();
            }
        }
    }

    public void onTouchDown(int x, int y) {
        if (!this.isTouched) {
            this.onFirstTouch(x, y);
            this.isTouched = false;
        }
    }

    public void onFirstTouch(int x, int y) {
    }

    public void onTouched(int x, int y) {
        this.isTouched = false;
    }

    public boolean isClickInGrid(int x, int y) {
        return (float)x >= Positions.gridPos.x && (float)x <= Positions.gridPos.x + Positions.gridSize * 4.0f && (float)y >= Positions.gridPos.y && (float)y <= Positions.gridPos.y + Positions.gridSize * 4.0f;
    }

    protected void onButtonClick() {
    }

    @Override
    public void onBackPressed() {
    }

    public void displayInterface() {
    }
}

