/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.screens;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.utils.Array;
import com.takyon.chess.utils.Fonts;
import com.takyon.gamelib.GDXButton;
import com.takyon.gamelib.GDXDialog;
import com.takyon.gamelib.GDXGame;
import com.takyon.gamelib.GDXGameNet;
import com.takyon.gamelib.GDXText;
import com.takyon.gamelib.GameScreen;
import com.takyon.gamelib.network.JoueurNetLine;
import com.takyon.gamelib.network.Partie;
import com.takyon.gamelib.network.PlayerNet;
import com.takyon.gamelib.network.server.RequestListeJoueursMessage;
import java.util.ArrayList;
import java.util.Collection;

public class ScreenParties
extends GameScreen {
    private GDXButton btnRefreshGame;
    public static ArrayList<Partie> listParties;
    public static GDXDialog inviteDialog;
    public static ArrayList<JoueurNetLine> listJoueurs;

    @Override
    public void init() {
        inviteDialog = new GDXDialog();
        listParties = new ArrayList();
        listJoueurs = new ArrayList();
        this.btnRefreshGame = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/refresh", true, false, false);
        this.btnRefreshGame.setPosition(550.0f, 450.0f);
    }

    public static void refreshJoueurs(Collection<PlayerNet> joueurs) {
        int c = 0;
        listJoueurs.clear();
        for (PlayerNet playerNet : joueurs) {
            if (playerNet.id == GDXGameNet.playerNet.id) continue;
            GDXText text = new GDXText(Fonts.TEXT, playerNet.name);
            GDXButton button = new GDXButton("pics/interface/bouton", true, false, false);
            button.setPosition(650.0f, c * 100);
            JoueurNetLine joueurLine = new JoueurNetLine();
            joueurLine.joueur = playerNet;
            joueurLine.text = text;
            joueurLine.button = button;
            listJoueurs.add(joueurLine);
            ++c;
        }
    }

    public static void refreshGames(Array<Partie> parties) {
        int c = 0;
        listParties.clear();
        for (Partie partie : parties) {
            if (partie.hoteID == GDXGameNet.playerNet.id) continue;
            GDXText text = new GDXText(Fonts.TEXT, partie.playerName);
            Button button = new Button((Actor)new Image(new Texture("pics/interface/bouton")), new Button.ButtonStyle());
            button.setPosition(650.0f, (float)(c * 100));
            partie.text = text;
            partie.button = button;
            listParties.add(partie);
            ++c;
        }
    }

    @Override
    public void display() {
        this.btnRefreshGame.draw();
        for (JoueurNetLine line : listJoueurs) {
            line.text.draw();
        }
        inviteDialog.draw();
    }

    @Override
    public void firstInit() {
    }

    @Override
    public void finish() {
    }

    @Override
    public void process(float dt) {
        for (JoueurNetLine joueurNetLine : listJoueurs) {
        }
    }

    @Override
    public void onTouched(int x, int y, int pointer, int button) {
        if (this.btnRefreshGame.isClicked(x, y)) {
            GDXGameNet.clientToServer.sendToServer(new RequestListeJoueursMessage());
        }
    }
}

