/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.dmqhbattle.dalles;

import com.takyon.chess.utils.Positions;
import com.takyon.dmqhbattle.DmqhPlayer;
import com.takyon.dmqhbattle.GridDmqh;
import com.takyon.dmqhbattle.dalles.DalleFactory;
import com.takyon.dmqhbattle.dalles.GridObject;
import com.takyon.gamelib.DrawableObject;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Scene2D;

public class Dalle
extends DrawableObject
implements GridObject {
    public static boolean isDebug = false;
    public static float SIZE = 256.0f;
    public GDXImage image;
    protected boolean isVisible = true;
    protected float alpha = 1.0f;
    public int i;
    public int j;
    protected int start_i;
    protected int start_j;
    protected int end_i;
    protected int end_j;
    protected Position endPosition = new Position();
    protected int dx = 0;
    protected int dy = 0;
    public GridDmqh grid;
    public DmqhPlayer player;
    public State state;
    public static float speedAppear = 0.0f;
    public static float speed;

    public Dalle(int i, int j) {
        this.setVisible(true);
    }

    public Dalle(GridDmqh grid, GDXImage image, int i, int j, int value) {
        this(i, j);
        this.image = image;
        this.grid = grid;
        this.setCoords(i, j);
        grid.setValue(i, j, value);
        this.state = State.STATIC;
    }

    public void init() {
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public void move(int i1, int j1, int i2, int j2) {
        this.start_i = i1;
        this.start_j = j1;
        this.end_i = i2;
        this.end_j = j2;
        this.endPosition.set((float)this.grid.positionX + (float)this.end_i * Positions.gridSizePlusGap, (float)this.grid.positionY + (float)this.end_j * Positions.gridSizePlusGap + Positions.gridGap / 2.0f);
        this.dx = (int)Math.signum(this.end_i - this.start_i);
        this.dy = (int)Math.signum(this.end_j - this.start_j);
        this.state = State.MOVING;
    }

    public void stop() {
        this.dx = 0;
        this.dy = 0;
        this.state = State.STATIC;
        this.grid.setDalle(this.end_i, this.end_j, this);
        this.grid.setDalle(this.start_i, this.start_j, null);
        this.setCoords(this.end_i, this.end_j);
        this.setImage();
    }

    public void setCoords(int i, int j) {
        this.i = i;
        this.j = j;
        this.setPosition((float)this.grid.positionX + (float)i * Positions.gridSizePlusGap, (float)this.grid.positionY + (float)j * Positions.gridSizePlusGap + Positions.gridGap / 2.0f);
    }

    @Override
    public Position getPositionScale() {
        this.positionScaled.x = this.getPosition().x * this.grid.ratio * Scene2D.RATIO;
        this.positionScaled.y = ((float)Scene2D.SCREEN_HEIGHT_BASE - (this.getPosition().y + this.image.getHeight()) * this.grid.ratio) * Scene2D.RATIO;
        return this.positionScaled;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean b) {
        this.isVisible = b;
    }

    @Override
    public void setImage() {
        int value = this.grid.getValue(this.i, this.j);
        if (value > 0) {
            this.image = DalleFactory.getImage(value);
        }
    }

    @Override
    public void setImage(int value) {
        if (value > 0) {
            this.image = DalleFactory.getImage(value);
        }
    }

    @Override
    public void logic(float dt) {
        switch (this.state) {
            case POPING: {
                this.alpha += speedAppear * dt;
                if (!(this.alpha > 1.0f)) break;
                this.alpha = 1.0f;
                this.state = State.STATIC;
                break;
            }
            case MOVING: {
                if (this.dx > 0) {
                    this.getPosition().x += speed * (float)this.dx * dt;
                    if (!(this.getPosition().x > this.endPosition.x)) break;
                    this.stop();
                    break;
                }
                if (this.dx < 0) {
                    this.getPosition().x += speed * (float)this.dx * dt;
                    if (!(this.getPosition().x < this.endPosition.x)) break;
                    this.stop();
                    break;
                }
                if (this.dy > 0) {
                    this.getPosition().y += speed * (float)this.dy * dt;
                    if (!(this.getPosition().y > this.endPosition.y)) break;
                    this.stop();
                    break;
                }
                if (this.dy < 0) {
                    this.getPosition().y += speed * (float)this.dy * dt;
                    if (!(this.getPosition().y < this.endPosition.y)) break;
                    this.stop();
                    break;
                }
                this.stop();
                break;
            }
        }
    }

    public boolean hasSameCoords(Dalle dalle) {
        return this.i == dalle.i && this.j == dalle.j;
    }

    public void pop() {
        this.state = State.POPING;
        this.alpha = 0.0f;
        this.grid.setDalle(this.i, this.j, this);
    }

    @Override
    public void draw() {
        if (this.isVisible) {
            Position position = this.getPositionScale();
            this.image.setAlpha(this.alpha);
            GDXImage.draw(this.image.texture, position.x, position.y, this.image.getWidth() * Scene2D.RATIO * this.grid.ratio, this.image.getHeight() * Scene2D.RATIO * this.grid.ratio);
        }
    }

    public String toString() {
        return "<i=" + this.i + " j=" + this.j + " v= " + this.grid.getValue(this.i, this.j) + " state = " + (Object)((Object)this.state) + ">";
    }

    public static enum State {
        POPING,
        STATIC,
        MOVING,
        EXPLODING;

    }
}

