/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Disposable;
import com.takyon.gamelib.DrawableObject;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Rectangle;
import com.takyon.gamelib.Scene2D;
import java.util.ArrayList;

public class GDXImage
extends DrawableObject {
    public Texture texture;
    public TextureRegion textureRegion;
    public static SpriteBatch batch;
    public boolean isBlending = false;
    public Rectangle rectangle;
    public Color batchColor = new Color();
    public static ArrayList<Disposable> textures;

    public GDXImage() {
        this.batchColor.set(1.0f, 1.0f, 1.0f, 1.0f);
        textures = new ArrayList();
    }

    public GDXImage(Texture texture) {
        this();
        this.texture = texture;
        textures.add((Disposable)texture);
        this.textureRegion = new TextureRegion(texture);
    }

    public GDXImage(String name) {
        this(new Texture(name));
    }

    @Override
    public float getAlpha() {
        return this.batchColor.a;
    }

    @Override
    public void setAlpha(float alpha) {
        this.batchColor.a = alpha;
    }

    @Override
    public Position getPositionScale() {
        this.positionScaled.x = this.getPosition().x * Scene2D.RATIO;
        this.positionScaled.y = ((float)Scene2D.SCREEN_HEIGHT_BASE - this.getPosition().y - (float)this.texture.getHeight()) * Scene2D.RATIO;
        return this.positionScaled;
    }

    public boolean isPointed(int x, int y) {
        return (float)x > this.getPosition().x && (float)y > this.getPosition().y && (float)x < this.getPosition().x + (float)this.texture.getTextureData().getWidth() && (float)y < this.getPosition().y + (float)this.texture.getTextureData().getHeight();
    }

    @Override
    public void draw() {
        if (this.isVisible()) {
            this.getPositionScale();
            this.draw(this.positionScaled.x, this.positionScaled.y, this.getAlpha());
        }
    }

    public float getWidth() {
        return this.texture.getWidth();
    }

    public float getHeight() {
        return this.texture.getHeight();
    }

    public void draw(Position position) {
        this.draw(position.x, position.y);
    }

    public void draw(float x, float y) {
        batch.setColor(this.batchColor.r, this.batchColor.g, this.batchColor.b, this.batchColor.a);
        batch.draw(this.texture, (float)Graphics.decalageX + x, y, (float)this.texture.getWidth() * Scene2D.RATIO, (float)this.texture.getHeight() * Scene2D.RATIO);
    }

    public void draw(float x, float y, float w, float h) {
        batch.setColor(this.batchColor.r, this.batchColor.g, this.batchColor.b, this.batchColor.a);
        batch.draw(this.texture, (float)Graphics.decalageX + x, y, w * Scene2D.RATIO, h * Scene2D.RATIO);
    }

    public void drawRotation(float x, float y, float w, float h, float angle) {
        batch.setColor(this.batchColor.r, this.batchColor.g, this.batchColor.b, this.batchColor.a);
        batch.draw(this.textureRegion, (float)Graphics.decalageX + x, y, 0.0f, 0.0f, w * Scene2D.RATIO, h * Scene2D.RATIO, 1.0f, 1.0f, angle);
    }

    public void draw(float x, float y, float w, float h, float alpha) {
        batch.setColor(this.batchColor.r, this.batchColor.g, this.batchColor.b, alpha);
        batch.draw(this.texture, (float)Graphics.decalageX + x, y, w * Scene2D.RATIO, h * Scene2D.RATIO);
    }

    public void draw(float x, float y, float alpha) {
        batch.setColor(this.batchColor.r, this.batchColor.g, this.batchColor.b, alpha);
        batch.draw(this.texture, (float)Graphics.decalageX + x, y, (float)this.texture.getWidth() * Scene2D.RATIO, (float)this.texture.getHeight() * Scene2D.RATIO);
    }

    public static void draw(Texture texture, float x, float y) {
        batch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        batch.draw(texture, (float)Graphics.decalageX + x, y, (float)texture.getWidth() * Scene2D.RATIO, (float)texture.getHeight() * Scene2D.RATIO);
    }

    public static void draw(Texture texture, float x, float y, float alpha) {
        batch.setColor(1.0f, 1.0f, 1.0f, alpha);
        batch.draw(texture, (float)Graphics.decalageX + x, y, (float)texture.getWidth() * Scene2D.RATIO, (float)texture.getHeight() * Scene2D.RATIO);
    }

    public static void draw(Texture texture, float x, float y, float width, float height) {
        batch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        batch.draw(texture, (float)Graphics.decalageX + x, y, width, height);
    }

    public static void draw(Texture texture, float x, float y, float width, float height, float alpha) {
        batch.setColor(1.0f, 1.0f, 1.0f, alpha);
        batch.draw(texture, (float)Graphics.decalageX + x, y, width, height);
    }

    public static void draw(Texture texture, float x, float y, float width, float height, float u1, float v1, float u2, float v2, float alpha) {
        batch.setColor(1.0f, 1.0f, 1.0f, alpha);
        batch.draw(texture, (float)Graphics.decalageX + x, y, width, height, u1, v1, u2, v2);
    }

    public static void draw(Texture texture, float x, float y, float width, float height, float u1, float v1, float u2, float v2) {
        batch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        batch.draw(texture, (float)Graphics.decalageX + x, y, width, height, u1, v1, u2, v2);
    }
}

