/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.takyon.gamelib.DrawableObject;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.GDXTextStyle;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Scene2D;

public class GDXText
extends DrawableObject {
    public String text = "";
    public float textX;
    public GDXTextStyle textStyle;

    public GDXText(GDXTextStyle textStyle) {
        this.textStyle = textStyle;
    }

    public GDXText(GDXTextStyle textStyle, String text) {
        this(textStyle);
        this.setText(text);
    }

    public void setText(String text) {
        this.text = text;
        if (this.textStyle.align == 0) {
            this.textX = 0.0f;
        } else if (this.textStyle.align == 2) {
            this.textX = -this.getWidth() / 2.0f;
        } else if (this.textStyle.align == 1) {
            this.textX = -this.getWidth() + this.textStyle.font.getBounds((CharSequence)new StringBuilder().append((char)text.charAt((int)0)).toString()).width;
        }
    }

    public void addChar(char character) {
        this.setText(String.valueOf(this.text) + character);
    }

    public void removeChar() {
        this.setText(this.text.substring(0, this.text.length() - 2));
    }

    @Override
    public void setAlpha(float akpha) {
        Color color = this.textStyle.font.getColor();
        this.textStyle.font.setColor(color.r, color.g, color.b, akpha);
    }

    public float getWidth() {
        return this.textStyle.font.getBounds((CharSequence)this.text).width;
    }

    public float getHeight() {
        return this.textStyle.font.getBounds((CharSequence)this.text).height;
    }

    @Override
    public void draw() {
        float x = this.position.x * Scene2D.RATIO;
        float y = ((float)Scene2D.SCREEN_HEIGHT_BASE - this.position.y) * Scene2D.RATIO;
        this.textStyle.font.drawWrapped((Batch)GDXImage.batch, (CharSequence)this.text, (float)Graphics.decalageX + x + this.textX, y, (float)this.textStyle.wrapWidth);
    }

    public String toString() {
        return this.text;
    }
}

