/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.GDXButton;
import java.util.ArrayList;

public abstract class GameScreen {
    boolean initialised = false;
    public boolean isResourcesLoaded = false;
    public boolean loading;
    public static GameScreen currentScreen;
    public static GameScreen nextScreen;
    public boolean isEnabled = true;
    public boolean isTouchDown = false;
    public boolean isPopup = false;
    public boolean isConfirmMandatory = false;
    public GameScreen previousScreen;
    public ArrayList<GDXButton> buttons = new ArrayList();

    public void initalise() {
        if (!this.initialised) {
            this.firstInit();
            this.init();
        } else {
            this.init();
        }
        this.initialised = true;
    }

    public abstract void firstInit();

    public abstract void init();

    public void initAfterConfirm() {
    }

    public abstract void finish();

    public abstract void process(float var1);

    public abstract void display();

    public void dispose() {
    }

    public void doneLoading() {
    }

    public static void checkScreenChange() {
        if (nextScreen != null) {
            GameScreen.setScreen(nextScreen);
            nextScreen = null;
        }
    }

    public static void setCurrentScreen(GameScreen nextScreen) {
        currentScreen = nextScreen;
    }

    public static void setScreen(GameScreen nextScreen) {
        if (currentScreen != null) {
            if (!nextScreen.isPopup) {
                currentScreen.finish();
            }
            nextScreen.previousScreen = currentScreen;
        }
        currentScreen = nextScreen;
        if (GameScreen.currentScreen.previousScreen == null || GameScreen.currentScreen.previousScreen != null && !GameScreen.currentScreen.previousScreen.isPopup) {
            currentScreen.initalise();
        }
    }

    public static void changeScreen(GameScreen screen) {
        if (currentScreen != null) {
            GameScreen.currentScreen.isEnabled = false;
        }
        if ((nextScreen = screen) != null) {
            GameScreen.nextScreen.isEnabled = true;
        }
    }

    public void onTouchDown(int x, int y, int pointer, int button) {
    }

    public void onTouched(int x, int y, int pointer, int button) {
    }

    public void onBackPressed() {
    }

    public void keyTyped(char character) {
    }

    public void keyUp(int keycode) {
    }

    public void mouseMoved(int screenX, int screenY) {
    }

    public void mouseDragged(int screenX, int screenY, int pointer) {
    }

    public void fling(float velocityX, float velocityY, int button) {
    }

    public void displayOSD() {
    }
}

