/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.Matrix3x3;
import com.takyon.gamelib.Quaternion;
import com.takyon.gamelib.Vector2d;
import com.takyon.gamelib.Vector3d;
import com.takyon.gamelib.Vector4d;
import java.io.Serializable;

public class Point
implements Serializable {
    public float x;
    public float y;
    public float z;

    public Point() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Point(Point point) {
        this.x = point.x;
        this.y = point.y;
        this.z = point.z;
    }

    public Point(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Point(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(Point point) {
        this.x = point.x;
        this.y = point.y;
        this.z = point.z;
    }

    public void translate(Vector2d v) {
        this.x += v.x;
        this.y += v.y;
    }

    public void translate(Vector3d v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public void translate(float tx, float ty) {
        this.x += tx;
        this.y += ty;
    }

    public void translate(float tx, float ty, float tz) {
        this.x += tx;
        this.y += ty;
        this.z += tz;
    }

    public void multiplyWithMatrix(float a, float b, float c, float d) {
        this.x = a * this.x + c * this.y;
        this.y = b * this.x + d * this.y;
    }

    public void multiplyWithwMatrix3x3(Matrix3x3 m) {
        float[] value = new float[3];
        float[] res = new float[3];
        value[0] = this.x;
        value[1] = this.y;
        value[2] = this.z;
        int c = 0;
        while (c < 3) {
            res[c] = 0.0f;
            int r = 0;
            while (r < 3) {
                res[c] = res[c] + value[r] * m.value[r][c];
                ++r;
            }
            ++c;
        }
        this.x = res[0];
        this.y = res[1];
        this.z = res[2];
    }

    public void rotate(float dh, float dp, float dr) {
        Quaternion heading = new Quaternion();
        Quaternion pitch = new Quaternion();
        Quaternion roll = new Quaternion();
        Quaternion rot = new Quaternion();
        heading.setFromAxisAngle(new Vector4d(0.0f, 1.0f, 0.0f, dh * ((float)Math.PI / 180)));
        pitch.setFromAxisAngle(new Vector4d(1.0f, 0.0f, 0.0f, dp * ((float)Math.PI / 180)));
        roll.setFromAxisAngle(new Vector4d(0.0f, 0.0f, 1.0f, dr * ((float)Math.PI / 180)));
        Quaternion.mul(heading, pitch, rot);
        Quaternion.mul(rot, roll, rot);
        Matrix3x3 m = new Matrix3x3(rot);
        this.multiplyWithwMatrix3x3(m);
    }

    public void rotate(float dh, float dp, float dr, Vector3d boneVec) {
        Quaternion heading = new Quaternion();
        Quaternion pitch = new Quaternion();
        Quaternion roll = new Quaternion();
        Quaternion rot = new Quaternion();
        heading.setFromAxisAngle(new Vector4d(0.0f, 1.0f, 0.0f, dh * ((float)Math.PI / 180)));
        pitch.setFromAxisAngle(new Vector4d(1.0f, 0.0f, 0.0f, dp * ((float)Math.PI / 180)));
        roll.setFromAxisAngle(new Vector4d(0.0f, 0.0f, 1.0f, dr * ((float)Math.PI / 180)));
        Quaternion.mul(heading, pitch, rot);
        Quaternion.mul(rot, roll, rot);
        Matrix3x3 m = new Matrix3x3(rot);
        this.multiplyWithwMatrix3x3(m);
    }

    public Point rotatePoint(float dh, float dp, float dr) {
        Point point = new Point(this.x, this.y, this.z);
        Quaternion heading = new Quaternion();
        Quaternion pitch = new Quaternion();
        Quaternion roll = new Quaternion();
        Quaternion rot = new Quaternion();
        heading.setFromAxisAngle(new Vector4d(0.0f, 1.0f, 0.0f, dh * ((float)Math.PI / 180)));
        pitch.setFromAxisAngle(new Vector4d(1.0f, 0.0f, 0.0f, dp * ((float)Math.PI / 180)));
        roll.setFromAxisAngle(new Vector4d(0.0f, 0.0f, 1.0f, dr * ((float)Math.PI / 180)));
        Quaternion.mul(roll, pitch, rot);
        Quaternion.mul(rot, heading, rot);
        Matrix3x3 m = new Matrix3x3(rot);
        point.multiplyWithwMatrix3x3(m);
        return point;
    }

    public void rotate(float dh, float dp, float dr, Point center) {
        this.translate(-center.x, -center.y, -center.z);
        this.rotate(dh, dp, dr);
        this.translate(center.x, center.y, center.z);
    }

    public void rotate(float dh, float dp, float dr, Point center, Vector3d axe_x, Vector3d axe_y, Vector3d axe_z) {
        this.translate(-center.x, -center.y, -center.z);
        this.rotate(dh, dp, dr, axe_x, axe_y, axe_z);
        this.translate(center.x, center.y, center.z);
    }

    public void rotate(float dh, float dp, float dr, Vector3d axe_x, Vector3d axe_y, Vector3d axe_z) {
        Quaternion heading = new Quaternion();
        Quaternion pitch = new Quaternion();
        Quaternion roll = new Quaternion();
        Quaternion rot = new Quaternion();
        heading.setFromAxisAngle(new Vector4d(axe_y.x, axe_y.y, axe_y.z, dh * ((float)Math.PI / 180)));
        pitch.setFromAxisAngle(new Vector4d(axe_x.x, axe_x.y, axe_x.z, dp * ((float)Math.PI / 180)));
        roll.setFromAxisAngle(new Vector4d(axe_z.x, axe_z.y, axe_z.z, dr * ((float)Math.PI / 180)));
        Quaternion.mul(roll, pitch, rot);
        Quaternion.mul(rot, heading, rot);
        Matrix3x3 m = new Matrix3x3(rot);
        this.multiplyWithwMatrix3x3(m);
    }

    public Point getTranslatedPoint(Vector2d v) {
        return new Point(this.x + v.x, this.y + v.y);
    }

    public Point getTranslatedPoint(Vector3d v) {
        return new Point(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Point getTranslatedPoint(float tx, float ty) {
        return new Point(this.x + tx, this.y + ty);
    }

    public Point getTranslatedPoint(float tx, float ty, float tz) {
        return new Point(this.x + tx, this.y + ty, this.z + tz);
    }

    public Point getMultiplyedWithMatrixPoint(float a, float b, float c, float d) {
        return new Point(a * this.x + c * this.y, b * this.x + d * this.y);
    }

    public Point getMultiplyedWith3x3MatrixPoint(Matrix3x3 m) {
        float[] value = new float[3];
        float[] res = new float[3];
        value[0] = this.x;
        value[1] = this.y;
        value[2] = this.z;
        int c = 0;
        while (c < 3) {
            res[c] = 0.0f;
            int r = 0;
            while (r < 3) {
                res[c] = res[c] + value[r] * m.value[r][c];
                ++r;
            }
            ++c;
        }
        this.x = res[0];
        this.y = res[1];
        this.z = res[2];
        return new Point(this.x, this.y, this.z);
    }

    public Point getRotatedPoint(float h, float p, float r) {
        Quaternion heading = new Quaternion();
        Quaternion pitch = new Quaternion();
        Quaternion roll = new Quaternion();
        Quaternion rot = new Quaternion();
        heading.setFromAxisAngle(new Vector4d(0.0f, 1.0f, 0.0f, h * ((float)Math.PI / 180)));
        pitch.setFromAxisAngle(new Vector4d(1.0f, 0.0f, 0.0f, p * ((float)Math.PI / 180)));
        roll.setFromAxisAngle(new Vector4d(0.0f, 0.0f, 1.0f, r * ((float)Math.PI / 180)));
        Quaternion.mul(heading, pitch, rot);
        Quaternion.mul(rot, roll, rot);
        Matrix3x3 m = new Matrix3x3(rot);
        return this.getMultiplyedWith3x3MatrixPoint(m);
    }

    private void isIn() {
    }

    public boolean equals(Point point) {
        return this.x == point.x && this.y == point.y && this.z == point.z;
    }

    public String toString() {
        return " (x:" + this.x + " y:" + this.y + " z:" + this.z + ")";
    }
}

