/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.Point;
import com.takyon.gamelib.Vector2d;
import com.takyon.gamelib.Vector3d;

public class Position
extends Point {
    public Position() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Position(Point point) {
        this.x = point.x;
        this.y = point.y;
        this.z = point.z;
    }

    public Position(float x, float y) {
        super(x, y);
    }

    public Position(float x, float y, float z) {
        super(x, y, z);
    }

    public void set(Position position) {
        this.x = position.x;
        this.y = position.y;
        this.z = position.z;
    }

    @Override
    public String toString() {
        return "<" + this.x + "," + this.y + "," + this.z + ">";
    }

    public Vector2d toXY() {
        return new Vector2d(this.x, this.y);
    }

    public Position addVec(Vector2d vec) {
        return new Position(this.x + vec.x, this.y + vec.y);
    }

    public Position addVec(Vector3d vec) {
        return new Position(this.x + vec.x, this.y + vec.y, this.z + vec.z);
    }

    public Position subVec(Position position) {
        return new Position(this.x - position.x, this.y - position.y, this.z - position.z);
    }

    public void sub(Vector2d vec2d) {
        this.x -= vec2d.x;
        this.y -= vec2d.y;
    }

    public void sub(Vector3d vec3d) {
        this.x -= vec3d.x;
        this.y -= vec3d.y;
        this.z -= vec3d.z;
    }

    public void add(Vector2d vec2d) {
        this.x += vec2d.x;
        this.y += vec2d.y;
    }

    public void add(Vector3d vec3d) {
        this.x += vec3d.x;
        this.y += vec3d.y;
        this.z += vec3d.z;
    }
}

