/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.takyon.gamelib.Animation;
import com.takyon.gamelib.Resource;
import com.takyon.gamelib.Scene2D;
import com.takyon.gamelib.SpriteTexturedRectangle;
import java.io.FileNotFoundException;

public class SpriteAnimation
extends Animation {
    public transient SpriteTexturedRectangle[] texturedRectangles;
    public transient SpriteTexturedRectangle texturedRectangle;
    protected int currentTextureIndex = 0;
    public boolean isRevert = false;
    public transient boolean isMirror = false;
    public boolean isBig = false;
    public boolean isFolder = false;
    public String path;
    public String anims_array;
    public String numberFrames_array;

    public SpriteAnimation() {
    }

    public SpriteAnimation(String anim) {
        this.name = anim;
    }

    public SpriteAnimation(String path, float fps) {
        FileHandle[] images = Gdx.files.internal(path).list();
        this.numberFrames = images.length;
        this.texturedRectangles = new SpriteTexturedRectangle[this.numberFrames];
        this.fps = fps;
        this.TOTAL_TIME = (float)this.numberFrames / fps;
        this.path = path;
        this.isFolder = true;
        int i = 0;
        while (i < this.numberFrames) {
            String image = images[i].name();
            this.texturedRectangles[i] = Scene2D.igl.createSpriteTexture();
            this.texturedRectangles[i].spriteAnimation = this;
            try {
                this.texturedRectangles[i].setTexture(Scene2D.igl.textureLoader().loadTexture2D(String.valueOf(path) + "/" + image));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.texturedRectangles[i].columns = 1;
            this.texturedRectangles[i].width = this.texturedRectangles[i].texture.imageWidth / this.texturedRectangles[i].columns;
            this.texturedRectangles[i].height = this.texturedRectangles[i].texture.imageHeight / this.texturedRectangles[i].columns;
            this.texturedRectangles[i].width *= Scene2D.RATIO;
            this.texturedRectangles[i].height *= Scene2D.RATIO;
            ++i;
        }
        this.texturedRectangle = this.texturedRectangles[0];
    }

    public SpriteAnimation(String path, String anim, String[] anims, int[] numberFrames, int fps) {
        this.path = path;
        this.name = anim;
        int i = 0;
        while (i < numberFrames.length) {
            this.numberFrames += numberFrames[i];
            ++i;
        }
        this.fps = fps;
        this.isBig = true;
        this.texturedRectangles = new SpriteTexturedRectangle[anims.length];
        this.load(path, anims, numberFrames);
    }

    public SpriteAnimation(String path, String anim, int numberFrames, int fps) {
        this.path = path;
        this.name = anim;
        this.numberFrames = numberFrames;
        this.texturedRectangles = new SpriteTexturedRectangle[1];
        this.fps = fps;
        this.load(path, anim);
    }

    public SpriteAnimation(String path, String anim, int numberFrames, float time) {
        this.path = path;
        this.name = anim;
        this.numberFrames = numberFrames;
        this.texturedRectangles = new SpriteTexturedRectangle[1];
        this.load(path, anim);
    }

    public void load(String path, String[] anims, int[] numberFrames) {
        this.path = path;
        this.anims_array = "";
        this.numberFrames_array = "";
        int i = 0;
        while (i < anims.length) {
            this.anims_array = String.valueOf(this.anims_array) + anims[i] + " ";
            this.numberFrames_array = String.valueOf(this.numberFrames_array) + numberFrames[i] + " ";
            this.texturedRectangles[i] = Scene2D.igl.createSpriteTexture();
            this.texturedRectangles[i].spriteAnimation = this;
            try {
                this.texturedRectangles[i].setTexture(Scene2D.igl.textureLoader().loadTexture2D(String.valueOf(path) + "/" + anims[i] + ".png"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.texturedRectangles[i].numberFrames = numberFrames[i];
            this.texturedRectangles[i].columns = (int)Math.ceil(Math.sqrt(numberFrames[i]));
            this.texturedRectangles[i].width = this.texturedRectangles[i].texture.imageWidth / this.texturedRectangles[i].columns;
            this.texturedRectangles[i].height = this.texturedRectangles[i].texture.imageHeight / this.texturedRectangles[i].columns;
            this.texturedRectangles[i].width *= Scene2D.RATIO;
            this.texturedRectangles[i].height *= Scene2D.RATIO;
            this.texturedRectangles[i].TOTAL_TIME = (float)this.texturedRectangles[i].numberFrames / this.fps;
            ++i;
        }
        this.texturedRectangle = this.texturedRectangles[0];
    }

    public void load(String path, String anim) {
        this.path = path;
        this.texturedRectangles[0] = Scene2D.igl.createSpriteTexture();
        this.texturedRectangles[0].spriteAnimation = this;
        try {
            this.texturedRectangles[0].setTexture(Scene2D.igl.textureLoader().loadTexture2D(String.valueOf(path) + "/" + anim + ".png"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.texturedRectangles[0].numberFrames = this.numberFrames;
        this.texturedRectangles[0].columns = (int)Math.ceil(Math.sqrt(this.numberFrames));
        this.texturedRectangles[0].width = this.texturedRectangles[0].texture.imageWidth / this.texturedRectangles[0].columns;
        this.texturedRectangles[0].height = this.texturedRectangles[0].texture.imageHeight / this.texturedRectangles[0].columns;
        this.texturedRectangles[0].width *= Scene2D.RATIO;
        this.texturedRectangles[0].height *= Scene2D.RATIO;
        this.texturedRectangles[0].TOTAL_TIME = (float)this.texturedRectangles[0].numberFrames / this.fps;
        this.texturedRectangle = this.texturedRectangles[0];
    }

    @Override
    public void init() {
        if (this.isFolder) {
            String[] images = Resource.iLoader.listFiles(this.path);
            this.numberFrames = images.length;
            this.texturedRectangles = new SpriteTexturedRectangle[this.numberFrames];
            this.TOTAL_TIME = (float)this.numberFrames / this.fps;
            int i = 0;
            while (i < this.numberFrames) {
                String image = images[i];
                this.texturedRectangles[i] = Scene2D.igl.createSpriteTexture();
                this.texturedRectangles[i].spriteAnimation = this;
                try {
                    this.texturedRectangles[i].setTexture(Scene2D.igl.textureLoader().loadTexture2D(String.valueOf(this.path) + "/" + image));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                this.texturedRectangles[i].columns = 1;
                this.texturedRectangles[i].width = this.texturedRectangles[i].texture.imageWidth / this.texturedRectangles[i].columns;
                this.texturedRectangles[i].height = this.texturedRectangles[i].texture.imageHeight / this.texturedRectangles[i].columns;
                this.texturedRectangles[i].width *= Scene2D.RATIO;
                this.texturedRectangles[i].height *= Scene2D.RATIO;
                ++i;
            }
            this.texturedRectangle = this.texturedRectangles[0];
        } else if (this.isBig) {
            String[] anims_array = this.anims_array.split(" ");
            String[] nb_frames_array = this.numberFrames_array.split(" ");
            int[] nb_frames_int = new int[nb_frames_array.length];
            int i = 0;
            while (i < nb_frames_array.length) {
                nb_frames_int[i] = Integer.parseInt(nb_frames_array[i]);
                ++i;
            }
            this.texturedRectangles = new SpriteTexturedRectangle[anims_array.length];
            this.load(this.path, anims_array, nb_frames_int);
        } else {
            this.texturedRectangles = new SpriteTexturedRectangle[1];
            this.load(this.path, this.name);
        }
    }

    @Override
    public void run(float dt) {
        if (!this.finished) {
            if (!this.isRevert) {
                if (this.isFolder) {
                    this.time += dt;
                    this.currentTextureIndex = this.currentFrame;
                    this.texturedRectangle = this.texturedRectangles[this.currentTextureIndex];
                    if (this.time > this.TOTAL_TIME || this.currentFrame > this.numberFrames - 1) {
                        if (this.isLoop) {
                            this.currentTextureIndex = 0;
                            this.currentFrame = 0;
                            this.time = 0.0f;
                        } else {
                            this.currentFrame = this.numberFrames - 1;
                            this.finished = true;
                            return;
                        }
                    }
                    this.setCurrentFrame();
                } else {
                    this.texturedRectangle.time += dt;
                    this.texturedRectangle.currentFrame = (int)(this.fps * this.texturedRectangle.time);
                    if (this.texturedRectangle.time > this.texturedRectangle.TOTAL_TIME || this.texturedRectangle.currentFrame > this.texturedRectangle.numberFrames - 1) {
                        if (!this.isLoop) {
                            this.texturedRectangle.currentFrame = this.texturedRectangle.numberFrames - 1;
                            this.finished = true;
                            return;
                        }
                        this.texturedRectangle.currentFrame = 0;
                        this.texturedRectangle.time = 0.0f;
                        if (this.texturedRectangles.length > 1) {
                            this.texturedRectangle = this.nextTexture();
                        }
                    }
                }
            } else {
                this.texturedRectangle.time += dt;
                this.texturedRectangle.currentFrame = this.texturedRectangle.numberFrames - 1 - (int)(this.fps * this.texturedRectangle.time);
                if (this.texturedRectangle.time > this.texturedRectangle.TOTAL_TIME || this.texturedRectangle.currentFrame < 0) {
                    if (!this.isLoop) {
                        this.finished = true;
                        return;
                    }
                    this.texturedRectangle.currentFrame = this.texturedRectangle.numberFrames - 1;
                    this.texturedRectangle.time = 0.0f;
                    if (this.texturedRectangles.length > 1) {
                        this.texturedRectangle = this.nextTexture();
                    }
                }
            }
        }
    }

    protected void setCurrentFrame() {
        this.currentFrame = (int)(this.fps * this.time);
    }

    @Override
    public int getCurrentFrame() {
        if (this.isFolder) {
            return this.currentFrame;
        }
        int currentFrame = 0;
        if (this.texturedRectangles.length > 1) {
            int i = 0;
            while (i < this.texturedRectangles.length) {
                currentFrame += this.texturedRectangles[i].currentFrame;
                ++i;
            }
        } else {
            currentFrame = this.texturedRectangle.currentFrame;
        }
        return currentFrame;
    }

    @Override
    public float getTotalTime() {
        float totalTime = 0.0f;
        if (this.texturedRectangles.length > 1) {
            int i = 0;
            while (i < this.texturedRectangles.length) {
                totalTime += this.texturedRectangles[i].TOTAL_TIME;
                ++i;
            }
        } else {
            totalTime = this.texturedRectangle.TOTAL_TIME;
        }
        return totalTime;
    }

    private SpriteTexturedRectangle nextTexture() {
        ++this.currentTextureIndex;
        if (this.currentTextureIndex == this.texturedRectangles.length) {
            this.currentTextureIndex = 0;
        }
        return this.texturedRectangles[this.currentTextureIndex];
    }

    @Override
    public void start() {
        this.finished = false;
        int i = 0;
        while (i < this.texturedRectangles.length) {
            this.texturedRectangles[i].currentFrame = 0;
            this.texturedRectangles[i].time = 0.0f;
            ++i;
        }
        this.currentFrame = 0;
        this.time = 0.0f;
    }

    @Override
    public void stop() {
        this.finished = true;
        int i = 0;
        while (i < this.texturedRectangles.length) {
            this.texturedRectangles[i].currentFrame = 0;
            this.texturedRectangles[i].time = 0.0f;
            ++i;
        }
        this.currentFrame = 0;
        this.time = 0.0f;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void resetAlpha() {
        int i = 0;
        while (i < this.texturedRectangles.length) {
            this.texturedRectangles[i].color.alpha = 1.0f;
            ++i;
        }
    }

    public SpriteTexturedRectangle getFrame(int frame) {
        return this.texturedRectangles[frame];
    }

    public void drawFrame(int frame) {
        Scene2D.igl.glEnable(3042);
        if (!this.isMirror) {
            this.texturedRectangles[frame].draw();
        } else {
            this.texturedRectangles[frame].drawRevert();
        }
        Scene2D.igl.glDisable(3042);
    }

    @Override
    public void draw() {
        Scene2D.igl.glEnable(3042);
        if (!this.isMirror) {
            this.texturedRectangle.draw();
        } else {
            this.texturedRectangle.drawRevert();
        }
        Scene2D.igl.glDisable(3042);
    }

    @Override
    public String toString() {
        return "<name: " + this.name + ", nbframes: " + this.numberFrames + ", fps: " + this.fps + ">";
    }
}

