/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.FileResourceLoader;
import com.takyon.gamelib.Scene2D;
import com.takyon.gamelib.Texture;
import com.takyon.gamelib.TextureState;
import java.io.FileNotFoundException;
import java.util.HashMap;

public abstract class TextureLoader
extends FileResourceLoader {
    public static HashMap<String, Texture> textures = new HashMap();
    public static TextureState texture2dState;
    public static TextureState TEXTURE_2D;

    static {
        TEXTURE_2D = new TextureState(3553, 9729, 9729, 10496, 10496);
    }

    public abstract Texture loadPNGTexture2D(String var1) throws FileNotFoundException;

    public abstract Texture loadTGATexture2D(String var1) throws FileNotFoundException;

    public void reloadTextures() {
        try {
            for (String fileName : textures.keySet()) {
                if (fileName.endsWith("png")) {
                    this.loadPNGTexture2D(fileName);
                    continue;
                }
                if (!fileName.endsWith("tga")) continue;
                this.loadTGATexture2D(fileName);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public Texture loadTexture2D(String fileName) throws FileNotFoundException {
        texture2dState = TEXTURE_2D;
        if (textures.get(fileName) == null) {
            Texture texture = null;
            if (fileName.endsWith("png")) {
                texture = this.loadPNGTexture2D(fileName);
            } else if (fileName.endsWith("tga")) {
                texture = this.loadTGATexture2D(fileName);
            }
            texture.fileName = fileName;
            textures.put(fileName, texture);
            return texture;
        }
        return textures.get(fileName);
    }

    public Texture loadTexture2D(String fileName, TextureState textureState) throws FileNotFoundException {
        texture2dState = textureState;
        if (textures.get(fileName) == null) {
            Texture texture = this.loadPNGTexture2D(fileName);
            texture.fileName = fileName;
            textures.put(fileName, texture);
            return texture;
        }
        return textures.get(fileName);
    }

    public static void setTextureState(TextureState textureState) {
        if (textureState == null) {
            textureState = TEXTURE_2D;
        }
        Scene2D.igl.glTexParameter(textureState.target, 10241, textureState.minFilter);
        Scene2D.igl.glTexParameter(textureState.target, 10240, textureState.magFilter);
        Scene2D.igl.glTexParameter(textureState.target, 10242, textureState.repeat_x);
        Scene2D.igl.glTexParameter(textureState.target, 10243, textureState.repeat_y);
    }

    public void clear() {
    }
}

