/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.Matrix3x3;
import com.takyon.gamelib.Point;
import com.takyon.gamelib.Quaternion;
import com.takyon.gamelib.Vector2d;
import com.takyon.gamelib.Vector4d;

public class Vector3d
extends Point {
    public static Vector3d AXIS_X = new Vector3d(1.0f, 0.0f, 0.0f);
    public static Vector3d AXIS_Y = new Vector3d(0.0f, 1.0f, 0.0f);
    public static Vector3d AXIS_Z = new Vector3d(0.0f, 0.0f, 1.0f);

    public Vector3d() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vector3d(Point a, Point b) {
        this.x = b.x - a.x;
        this.y = b.y - a.y;
        this.z = b.z - a.z;
    }

    public Vector3d(Vector3d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vector3d(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void set(float x, float y) {
        this.x = x;
        this.y = y;
        this.z = 0.0f;
    }

    @Override
    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(Vector3d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vector2d toXY() {
        return new Vector2d(this.x, this.y);
    }

    public Vector3d addVec(Vector3d v) {
        return new Vector3d(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public void addXZ(Vector2d v) {
        this.x += v.x;
        this.z += v.y;
    }

    @Override
    public void translate(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public void add(Vector2d v) {
        this.x += v.x;
        this.y += v.y;
    }

    public void add(Vector3d v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public void sub(Vector2d v) {
        this.x -= v.x;
        this.y -= v.y;
    }

    public void sub(Vector3d v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public Vector3d subVec(Vector3d v) {
        return new Vector3d(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public void scale(float s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
    }

    public Vector3d scalev(float s) {
        return new Vector3d(this.x * s, this.y * s, this.z * s);
    }

    public float dotProd(Vector3d v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public Vector3d crossProd(Vector3d v) {
        return new Vector3d(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float unsignedAngle() {
        Vector3d v = new Vector3d(1.0f, 0.0f, 0.0f);
        return (float)Math.toDegrees(Math.acos(this.dotProd(v) / (this.length() * v.length())));
    }

    public float unsignedAngle(Vector3d v) {
        return (float)Math.toDegrees(Math.acos(this.dotProd(v) / (this.length() * v.length())));
    }

    public float signedAngle(Vector3d v, Vector3d axis) {
        Vector3d cv = this.crossProd(v);
        if (axis == AXIS_Z) {
            return Math.signum(cv.z) * (float)Math.toDegrees(Math.acos(this.dotProd(v) / (this.length() * v.length())));
        }
        if (axis == AXIS_X) {
            return Math.signum(cv.x) * (float)Math.toDegrees(Math.acos(this.dotProd(v) / (this.length() * v.length())));
        }
        if (axis == AXIS_Y) {
            return Math.signum(cv.y) * (float)Math.toDegrees(Math.acos(this.dotProd(v) / (this.length() * v.length())));
        }
        return 0.0f;
    }

    public float angle() {
        Vector3d v = new Vector3d(1.0f, 0.0f, 0.0f);
        return (float)(-this.crossProd(v).zsign()) * this.unsignedAngle();
    }

    public int zsign() {
        if (this.z > 0.0f) {
            return 1;
        }
        return -1;
    }

    public float angle(Vector3d v) {
        return Math.signum(this.dotProd(v)) * (float)Math.toDegrees(Math.asin(this.crossProd(v).length() / (this.length() * v.length())));
    }

    public Vector3d normalVec() {
        float l = this.length();
        return new Vector3d(this.x / l, this.y / l, this.z / l);
    }

    public void normalize() {
        float l = this.length();
        if (l == 0.0f) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
        } else {
            this.x /= l;
            this.y /= l;
            this.z /= l;
        }
    }

    public void matrixMult3(Matrix3x3 m) {
        float[] value = new float[3];
        float[] res = new float[3];
        value[0] = this.x;
        value[1] = this.y;
        value[2] = this.z;
        int c = 0;
        while (c < 3) {
            res[c] = 0.0f;
            int r = 0;
            while (r < 3) {
                res[c] = res[c] + value[r] * m.value[r][c];
                ++r;
            }
            ++c;
        }
        this.x = res[0];
        this.y = res[1];
        this.z = res[2];
    }

    public Vector3d matrixMult3v(Matrix3x3 m) {
        float[] value = new float[3];
        float[] res = new float[3];
        value[0] = this.x;
        value[1] = this.y;
        value[2] = this.z;
        int c = 0;
        while (c < 3) {
            res[c] = 0.0f;
            int r = 0;
            while (r < 3) {
                res[c] = res[c] + value[r] * m.value[r][c];
                ++r;
            }
            ++c;
        }
        return new Vector3d(res[0], res[1], res[1]);
    }

    public void rotate3(Vector3d axis, float a) {
        Matrix3x3 m = new Matrix3x3();
        m.rotate3(a, axis);
        this.matrixMult3(m);
    }

    public Vector3d rotate3v(Vector3d axis, float a) {
        Matrix3x3 m = new Matrix3x3();
        m.rotate3(a, axis);
        return this.matrixMult3v(m);
    }

    public void absZ() {
        this.z = Math.abs(this.z);
    }

    public void abs() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
    }

    public void reflect(Vector3d refaxe) {
        float a = this.angle(refaxe);
        this.rotate3(refaxe, 2.0f * a);
    }

    public Vector3d getRotated(float h, float p, float r) {
        Quaternion heading = new Quaternion();
        Quaternion pitch = new Quaternion();
        Quaternion roll = new Quaternion();
        Quaternion rot = new Quaternion();
        heading.setFromAxisAngle(new Vector4d(0.0f, 1.0f, 0.0f, h * ((float)Math.PI / 180)));
        pitch.setFromAxisAngle(new Vector4d(1.0f, 0.0f, 0.0f, p * ((float)Math.PI / 180)));
        roll.setFromAxisAngle(new Vector4d(0.0f, 0.0f, 1.0f, r * ((float)Math.PI / 180)));
        Quaternion.mul(roll, pitch, rot);
        Quaternion.mul(rot, heading, rot);
        Matrix3x3 m = new Matrix3x3(rot);
        return this.matrixMult3v(m);
    }

    @Override
    public void rotate(float h, float p, float r) {
        Quaternion heading = new Quaternion();
        Quaternion pitch = new Quaternion();
        Quaternion roll = new Quaternion();
        Quaternion rot = new Quaternion();
        heading.setFromAxisAngle(new Vector4d(0.0f, 1.0f, 0.0f, h * ((float)Math.PI / 180)));
        pitch.setFromAxisAngle(new Vector4d(1.0f, 0.0f, 0.0f, p * ((float)Math.PI / 180)));
        roll.setFromAxisAngle(new Vector4d(0.0f, 0.0f, 1.0f, r * ((float)Math.PI / 180)));
        Quaternion.mul(roll, pitch, rot);
        Quaternion.mul(rot, heading, rot);
        Matrix3x3 m = new Matrix3x3(rot);
        Vector3d v = this.matrixMult3v(m);
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    @Override
    public void multiplyWithwMatrix3x3(Matrix3x3 m) {
        float[] value = new float[3];
        float[] res = new float[3];
        value[0] = this.x;
        value[1] = this.y;
        value[2] = this.z;
        int c = 0;
        while (c < 3) {
            res[c] = 0.0f;
            int r = 0;
            while (r < 3) {
                res[c] = res[c] + value[r] * m.value[r][c];
                ++r;
            }
            ++c;
        }
        this.x = res[0];
        this.y = res[1];
        this.z = res[2];
    }

    @Override
    public String toString() {
        return "<" + this.x + "," + this.y + "," + this.z + ">";
    }
}

