/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.Encoder;
import org.xiph.speex.Filters;
import org.xiph.speex.Lpc;
import org.xiph.speex.Lsp;
import org.xiph.speex.Ltp;
import org.xiph.speex.Misc;
import org.xiph.speex.NbCodec;
import org.xiph.speex.NoiseSearch;
import org.xiph.speex.VQ;
import org.xiph.speex.Vbr;

public class NbEncoder
extends NbCodec
implements Encoder {
    public static final int[] NB_QUALITY_MAP = new int[]{1, 8, 2, 3, 3, 4, 4, 5, 5, 6, 7};
    private int bounded_pitch;
    private int[] pitch;
    private float pre_mem2;
    private float[] exc2Buf;
    private int exc2Idx;
    private float[] swBuf;
    private int swIdx;
    private float[] window;
    private float[] buf2;
    private float[] autocorr;
    private float[] lagWindow;
    private float[] lsp;
    private float[] old_lsp;
    private float[] interp_lsp;
    private float[] interp_lpc;
    private float[] bw_lpc1;
    private float[] bw_lpc2;
    private float[] rc;
    private float[] mem_sw;
    private float[] mem_sw_whole;
    private float[] mem_exc;
    private Vbr vbr;
    private int dtx_count;
    private float[] innov2;
    protected int complexity;
    protected int vbr_enabled;
    protected int vad_enabled;
    protected int abr_enabled;
    protected float vbr_quality;
    protected float relative_quality;
    protected float abr_drift;
    protected float abr_drift2;
    protected float abr_count;
    protected int sampling_rate;
    protected int submodeSelect;

    public void init(int n, int n2, int n3, int n4) {
        super.init(n, n2, n3, n4);
        this.complexity = 3;
        this.vbr_enabled = 0;
        this.vad_enabled = 0;
        this.abr_enabled = 0;
        this.vbr_quality = 8.0f;
        this.submodeSelect = 5;
        this.pre_mem2 = 0.0f;
        this.bounded_pitch = 1;
        this.exc2Buf = new float[n4];
        this.exc2Idx = n4 - this.windowSize;
        this.swBuf = new float[n4];
        this.swIdx = n4 - this.windowSize;
        this.window = Misc.window(this.windowSize, n2);
        this.lagWindow = Misc.lagWindow(n3, this.lag_factor);
        this.autocorr = new float[n3 + 1];
        this.buf2 = new float[this.windowSize];
        this.interp_lpc = new float[n3 + 1];
        this.interp_qlpc = new float[n3 + 1];
        this.bw_lpc1 = new float[n3 + 1];
        this.bw_lpc2 = new float[n3 + 1];
        this.lsp = new float[n3];
        this.qlsp = new float[n3];
        this.old_lsp = new float[n3];
        this.old_qlsp = new float[n3];
        this.interp_lsp = new float[n3];
        this.interp_qlsp = new float[n3];
        this.rc = new float[n3];
        this.mem_sp = new float[n3];
        this.mem_sw = new float[n3];
        this.mem_sw_whole = new float[n3];
        this.mem_exc = new float[n3];
        this.vbr = new Vbr();
        this.dtx_count = 0;
        this.abr_count = 0.0f;
        this.sampling_rate = 8000;
        this.awk1 = new float[n3 + 1];
        this.awk2 = new float[n3 + 1];
        this.awk3 = new float[n3 + 1];
        this.innov2 = new float[40];
        this.filters.init();
        this.pitch = new int[this.nbSubframes];
    }

    public int encode(Bits bits, float[] fArray) {
        int n;
        int n2;
        float f;
        float f2;
        int n3;
        int n4;
        System.arraycopy(this.frmBuf, this.frameSize, this.frmBuf, 0, this.bufSize - this.frameSize);
        this.frmBuf[this.bufSize - this.frameSize] = fArray[0] - this.preemph * this.pre_mem;
        for (n4 = 1; n4 < this.frameSize; ++n4) {
            this.frmBuf[this.bufSize - this.frameSize + n4] = fArray[n4] - this.preemph * fArray[n4 - 1];
        }
        this.pre_mem = fArray[this.frameSize - 1];
        System.arraycopy(this.exc2Buf, this.frameSize, this.exc2Buf, 0, this.bufSize - this.frameSize);
        System.arraycopy(this.excBuf, this.frameSize, this.excBuf, 0, this.bufSize - this.frameSize);
        System.arraycopy(this.swBuf, this.frameSize, this.swBuf, 0, this.bufSize - this.frameSize);
        for (n4 = 0; n4 < this.windowSize; ++n4) {
            this.buf2[n4] = this.frmBuf[n4 + this.frmIdx] * this.window[n4];
        }
        Lpc.autocorr(this.buf2, this.autocorr, this.lpcSize + 1, this.windowSize);
        this.autocorr[0] = this.autocorr[0] + 10.0f;
        this.autocorr[0] = this.autocorr[0] * this.lpc_floor;
        for (n4 = 0; n4 < this.lpcSize + 1; ++n4) {
            int n5 = n4;
            this.autocorr[n5] = this.autocorr[n5] * this.lagWindow[n4];
        }
        Lpc.wld(this.lpc, this.autocorr, this.rc, this.lpcSize);
        System.arraycopy(this.lpc, 0, this.lpc, 1, this.lpcSize);
        this.lpc[0] = 1.0f;
        int n6 = Lsp.lpc2lsp(this.lpc, this.lpcSize, this.lsp, 15, 0.2f);
        if (n6 == this.lpcSize) {
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                this.lsp[n4] = (float)Math.acos(this.lsp[n4]);
            }
        } else {
            if (this.complexity > 1) {
                n6 = Lsp.lpc2lsp(this.lpc, this.lpcSize, this.lsp, 11, 0.05f);
            }
            if (n6 == this.lpcSize) {
                for (n4 = 0; n4 < this.lpcSize; ++n4) {
                    this.lsp[n4] = (float)Math.acos(this.lsp[n4]);
                }
            } else {
                for (n4 = 0; n4 < this.lpcSize; ++n4) {
                    this.lsp[n4] = this.old_lsp[n4];
                }
            }
        }
        float f3 = 0.0f;
        for (n4 = 0; n4 < this.lpcSize; ++n4) {
            f3 += (this.old_lsp[n4] - this.lsp[n4]) * (this.old_lsp[n4] - this.lsp[n4]);
        }
        if (this.first != 0) {
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                this.interp_lsp[n4] = this.lsp[n4];
            }
        } else {
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                this.interp_lsp[n4] = 0.375f * this.old_lsp[n4] + 0.625f * this.lsp[n4];
            }
        }
        Lsp.enforce_margin(this.interp_lsp, this.lpcSize, 0.002f);
        for (n4 = 0; n4 < this.lpcSize; ++n4) {
            this.interp_lsp[n4] = (float)Math.cos(this.interp_lsp[n4]);
        }
        this.m_lsp.lsp2lpc(this.interp_lsp, this.interp_lpc, this.lpcSize);
        if (this.submodes[this.submodeID] == null || this.vbr_enabled != 0 || this.vad_enabled != 0 || this.submodes[this.submodeID].forced_pitch_gain != 0 || this.submodes[this.submodeID].lbr_pitch != -1) {
            int[] nArray = new int[6];
            float[] fArray2 = new float[6];
            Filters.bw_lpc(this.gamma1, this.interp_lpc, this.bw_lpc1, this.lpcSize);
            Filters.bw_lpc(this.gamma2, this.interp_lpc, this.bw_lpc2, this.lpcSize);
            Filters.filter_mem2(this.frmBuf, this.frmIdx, this.bw_lpc1, this.bw_lpc2, this.swBuf, this.swIdx, this.frameSize, this.lpcSize, this.mem_sw_whole, 0);
            Ltp.open_loop_nbest_pitch(this.swBuf, this.swIdx, this.min_pitch, this.max_pitch, this.frameSize, nArray, fArray2, 6);
            n3 = nArray[0];
            f2 = fArray2[0];
            for (n4 = 1; n4 < 6; ++n4) {
                if (!((double)fArray2[n4] > 0.85 * (double)f2) || !(Math.abs((double)nArray[n4] - (double)n3 / 2.0) <= 1.0 || Math.abs((double)nArray[n4] - (double)n3 / 3.0) <= 1.0 || Math.abs((double)nArray[n4] - (double)n3 / 4.0) <= 1.0) && !(Math.abs((double)nArray[n4] - (double)n3 / 5.0) <= 1.0)) continue;
                n3 = nArray[n4];
            }
        } else {
            n3 = 0;
            f2 = 0.0f;
        }
        Filters.fir_mem2(this.frmBuf, this.frmIdx, this.interp_lpc, this.excBuf, this.excIdx, this.frameSize, this.lpcSize, this.mem_exc);
        float f4 = 0.0f;
        for (n4 = 0; n4 < this.frameSize; ++n4) {
            f4 += this.excBuf[this.excIdx + n4] * this.excBuf[this.excIdx + n4];
        }
        f4 = (float)Math.sqrt(1.0f + f4 / (float)this.frameSize);
        if (this.vbr != null && (this.vbr_enabled != 0 || this.vad_enabled != 0)) {
            if (this.abr_enabled != 0) {
                float f5 = 0.0f;
                if (this.abr_drift2 * this.abr_drift > 0.0f) {
                    f5 = -1.0E-5f * this.abr_drift / (1.0f + this.abr_count);
                    if (f5 > 0.05f) {
                        f5 = 0.05f;
                    }
                    if (f5 < -0.05f) {
                        f5 = -0.05f;
                    }
                }
                this.vbr_quality += f5;
                if (this.vbr_quality > 10.0f) {
                    this.vbr_quality = 10.0f;
                }
                if (this.vbr_quality < 0.0f) {
                    this.vbr_quality = 0.0f;
                }
            }
            this.relative_quality = this.vbr.analysis(fArray, this.frameSize, n3, f2);
            if (this.vbr_enabled != 0) {
                int n7;
                int n8 = 0;
                f = 100.0f;
                for (n7 = 8; n7 > 0; --n7) {
                    n2 = (int)Math.floor(this.vbr_quality);
                    float f6 = n2 == 10 ? Vbr.nb_thresh[n7][n2] : (this.vbr_quality - (float)n2) * Vbr.nb_thresh[n7][n2 + 1] + ((float)(1 + n2) - this.vbr_quality) * Vbr.nb_thresh[n7][n2];
                    if (!(this.relative_quality > f6) || !(this.relative_quality - f6 < f)) continue;
                    n8 = n7;
                    f = this.relative_quality - f6;
                }
                n7 = n8;
                if (n7 == 0) {
                    if (this.dtx_count == 0 || (double)f3 > 0.05 || this.dtx_enabled == 0 || this.dtx_count > 20) {
                        n7 = 1;
                        this.dtx_count = 1;
                    } else {
                        n7 = 0;
                        ++this.dtx_count;
                    }
                } else {
                    this.dtx_count = 0;
                }
                this.setMode(n7);
                if (this.abr_enabled != 0) {
                    n2 = this.getBitRate();
                    this.abr_drift += (float)(n2 - this.abr_enabled);
                    this.abr_drift2 = 0.95f * this.abr_drift2 + 0.05f * (float)(n2 - this.abr_enabled);
                    this.abr_count = (float)((double)this.abr_count + 1.0);
                }
            } else {
                int n9;
                if (this.relative_quality < 2.0f) {
                    if (this.dtx_count == 0 || (double)f3 > 0.05 || this.dtx_enabled == 0 || this.dtx_count > 20) {
                        this.dtx_count = 1;
                        n9 = 1;
                    } else {
                        n9 = 0;
                        ++this.dtx_count;
                    }
                } else {
                    this.dtx_count = 0;
                    n9 = this.submodeSelect;
                }
                this.submodeID = n9;
            }
        } else {
            this.relative_quality = -1.0f;
        }
        bits.pack(0, 1);
        bits.pack(this.submodeID, 4);
        if (this.submodes[this.submodeID] == null) {
            for (n4 = 0; n4 < this.frameSize; ++n4) {
                this.swBuf[this.swIdx + n4] = 0.0f;
                this.exc2Buf[this.exc2Idx + n4] = 0.0f;
                this.excBuf[this.excIdx + n4] = 0.0f;
            }
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                this.mem_sw[n4] = 0.0f;
            }
            this.first = 1;
            this.bounded_pitch = 1;
            Filters.iir_mem2(this.excBuf, this.excIdx, this.interp_qlpc, this.frmBuf, this.frmIdx, this.frameSize, this.lpcSize, this.mem_sp);
            fArray[0] = this.frmBuf[this.frmIdx] + this.preemph * this.pre_mem2;
            for (n4 = 1; n4 < this.frameSize; ++n4) {
                this.frmIdx = n4;
                fArray[n4] = this.frmBuf[this.frmIdx] + this.preemph * fArray[n4 - 1];
            }
            this.pre_mem2 = fArray[this.frameSize - 1];
            return 0;
        }
        if (this.first != 0) {
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                this.old_lsp[n4] = this.lsp[n4];
            }
        }
        this.submodes[this.submodeID].lsqQuant.quant(this.lsp, this.qlsp, this.lpcSize, bits);
        if (this.submodes[this.submodeID].lbr_pitch != -1) {
            bits.pack(n3 - this.min_pitch, 7);
        }
        if (this.submodes[this.submodeID].forced_pitch_gain != 0) {
            int n10 = (int)Math.floor(0.5 + (double)(15.0f * f2));
            if (n10 > 15) {
                n10 = 15;
            }
            if (n10 < 0) {
                n10 = 0;
            }
            bits.pack(n10, 4);
            f2 = 0.066667f * (float)n10;
        }
        if ((n = (int)Math.floor(0.5 + 3.5 * Math.log(f4))) < 0) {
            n = 0;
        }
        if (n > 31) {
            n = 31;
        }
        f4 = (float)Math.exp((double)n / 3.5);
        bits.pack(n, 5);
        if (this.first != 0) {
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                this.old_qlsp[n4] = this.qlsp[n4];
            }
        }
        float[] fArray3 = new float[this.subframeSize];
        float[] fArray4 = new float[this.subframeSize];
        float[] fArray5 = new float[this.subframeSize];
        float[] fArray6 = new float[this.lpcSize];
        float[] fArray7 = new float[this.frameSize];
        for (n4 = 0; n4 < this.frameSize; ++n4) {
            fArray7[n4] = this.frmBuf[this.frmIdx + n4];
        }
        for (n = 0; n < this.nbSubframes; ++n) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15 = this.subframeSize * n;
            n2 = this.frmIdx + n15;
            int n16 = this.excIdx + n15;
            int n17 = this.swIdx + n15;
            int n18 = this.exc2Idx + n15;
            float f7 = (float)(1.0 + (double)n) / (float)this.nbSubframes;
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                this.interp_lsp[n4] = (1.0f - f7) * this.old_lsp[n4] + f7 * this.lsp[n4];
            }
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                this.interp_qlsp[n4] = (1.0f - f7) * this.old_qlsp[n4] + f7 * this.qlsp[n4];
            }
            Lsp.enforce_margin(this.interp_lsp, this.lpcSize, 0.002f);
            Lsp.enforce_margin(this.interp_qlsp, this.lpcSize, 0.002f);
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                this.interp_lsp[n4] = (float)Math.cos(this.interp_lsp[n4]);
            }
            this.m_lsp.lsp2lpc(this.interp_lsp, this.interp_lpc, this.lpcSize);
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                this.interp_qlsp[n4] = (float)Math.cos(this.interp_qlsp[n4]);
            }
            this.m_lsp.lsp2lpc(this.interp_qlsp, this.interp_qlpc, this.lpcSize);
            f7 = 1.0f;
            this.pi_gain[n] = 0.0f;
            for (n4 = 0; n4 <= this.lpcSize; ++n4) {
                int n19 = n;
                this.pi_gain[n19] = this.pi_gain[n19] + f7 * this.interp_qlpc[n4];
                f7 = -f7;
            }
            Filters.bw_lpc(this.gamma1, this.interp_lpc, this.bw_lpc1, this.lpcSize);
            if (this.gamma2 >= 0.0f) {
                Filters.bw_lpc(this.gamma2, this.interp_lpc, this.bw_lpc2, this.lpcSize);
            } else {
                this.bw_lpc2[0] = 1.0f;
                this.bw_lpc2[1] = -this.preemph;
                for (n4 = 2; n4 <= this.lpcSize; ++n4) {
                    this.bw_lpc2[n4] = 0.0f;
                }
            }
            for (n4 = 0; n4 < this.subframeSize; ++n4) {
                this.excBuf[n16 + n4] = 0.0f;
            }
            this.excBuf[n16] = 1.0f;
            Filters.syn_percep_zero(this.excBuf, n16, this.interp_qlpc, this.bw_lpc1, this.bw_lpc2, fArray5, this.subframeSize, this.lpcSize);
            for (n4 = 0; n4 < this.subframeSize; ++n4) {
                this.excBuf[n16 + n4] = 0.0f;
            }
            for (n4 = 0; n4 < this.subframeSize; ++n4) {
                this.exc2Buf[n18 + n4] = 0.0f;
            }
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                fArray6[n4] = this.mem_sp[n4];
            }
            Filters.iir_mem2(this.excBuf, n16, this.interp_qlpc, this.excBuf, n16, this.subframeSize, this.lpcSize, fArray6);
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                fArray6[n4] = this.mem_sw[n4];
            }
            Filters.filter_mem2(this.excBuf, n16, this.bw_lpc1, this.bw_lpc2, fArray3, 0, this.subframeSize, this.lpcSize, fArray6, 0);
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                fArray6[n4] = this.mem_sw[n4];
            }
            Filters.filter_mem2(this.frmBuf, n2, this.bw_lpc1, this.bw_lpc2, this.swBuf, n17, this.subframeSize, this.lpcSize, fArray6, 0);
            for (n4 = 0; n4 < this.subframeSize; ++n4) {
                fArray4[n4] = this.swBuf[n17 + n4] - fArray3[n4];
            }
            for (n4 = 0; n4 < this.subframeSize; ++n4) {
                this.exc2Buf[n18 + n4] = 0.0f;
                this.excBuf[n16 + n4] = 0.0f;
            }
            if (this.submodes[this.submodeID].lbr_pitch != -1) {
                n14 = this.submodes[this.submodeID].lbr_pitch;
                if (n14 != 0) {
                    if (n3 < this.min_pitch + n14 - 1) {
                        n3 = this.min_pitch + n14 - 1;
                    }
                    if (n3 > this.max_pitch - n14) {
                        n3 = this.max_pitch - n14;
                    }
                    n13 = n3 - n14 + 1;
                    n12 = n3 + n14;
                } else {
                    n13 = n12 = n3;
                }
            } else {
                n13 = this.min_pitch;
                n12 = this.max_pitch;
            }
            if (this.bounded_pitch != 0 && n12 > n15) {
                n12 = n15;
            }
            this.pitch[n] = n11 = this.submodes[this.submodeID].ltp.quant(fArray4, this.swBuf, n17, this.interp_qlpc, this.bw_lpc1, this.bw_lpc2, this.excBuf, n16, n13, n12, f2, this.lpcSize, this.subframeSize, bits, this.exc2Buf, n18, fArray5, this.complexity);
            Filters.syn_percep_zero(this.excBuf, n16, this.interp_qlpc, this.bw_lpc1, this.bw_lpc2, fArray3, this.subframeSize, this.lpcSize);
            for (n4 = 0; n4 < this.subframeSize; ++n4) {
                int n20 = n4;
                fArray4[n20] = fArray4[n20] - fArray3[n4];
            }
            float f8 = 0.0f;
            n14 = n * this.subframeSize;
            for (n4 = 0; n4 < this.subframeSize; ++n4) {
                this.innov[n14 + n4] = 0.0f;
            }
            Filters.residue_percep_zero(fArray4, 0, this.interp_qlpc, this.bw_lpc1, this.bw_lpc2, this.buf2, this.subframeSize, this.lpcSize);
            for (n4 = 0; n4 < this.subframeSize; ++n4) {
                f8 += this.buf2[n4] * this.buf2[n4];
            }
            f8 = (float)Math.sqrt(0.1f + f8 / (float)this.subframeSize);
            f8 /= f4;
            if (this.submodes[this.submodeID].have_subframe_gain != 0) {
                int n21;
                f8 = (float)Math.log(f8);
                if (this.submodes[this.submodeID].have_subframe_gain == 3) {
                    n21 = VQ.index(f8, exc_gain_quant_scal3, 8);
                    bits.pack(n21, 3);
                    f8 = exc_gain_quant_scal3[n21];
                } else {
                    n21 = VQ.index(f8, exc_gain_quant_scal1, 2);
                    bits.pack(n21, 1);
                    f8 = exc_gain_quant_scal1[n21];
                }
                f8 = (float)Math.exp(f8);
            } else {
                f8 = 1.0f;
            }
            float f9 = 1.0f / (f8 *= f4);
            n4 = 0;
            while (n4 < this.subframeSize) {
                int n22 = n4++;
                fArray4[n22] = fArray4[n22] * f9;
            }
            this.submodes[this.submodeID].innovation.quant(fArray4, this.interp_qlpc, this.bw_lpc1, this.bw_lpc2, this.lpcSize, this.subframeSize, this.innov, n14, fArray5, bits, this.complexity);
            for (n4 = 0; n4 < this.subframeSize; ++n4) {
                int n23 = n14 + n4;
                this.innov[n23] = this.innov[n23] * f8;
            }
            for (n4 = 0; n4 < this.subframeSize; ++n4) {
                int n24 = n16 + n4;
                this.excBuf[n24] = this.excBuf[n24] + this.innov[n14 + n4];
            }
            if (this.submodes[this.submodeID].double_codebook != 0) {
                float[] fArray8 = new float[this.subframeSize];
                n4 = 0;
                while (n4 < this.subframeSize) {
                    int n25 = n4++;
                    fArray4[n25] = (float)((double)fArray4[n25] * 2.2);
                }
                this.submodes[this.submodeID].innovation.quant(fArray4, this.interp_qlpc, this.bw_lpc1, this.bw_lpc2, this.lpcSize, this.subframeSize, fArray8, 0, fArray5, bits, this.complexity);
                n4 = 0;
                while (n4 < this.subframeSize) {
                    int n26 = n4++;
                    fArray8[n26] = (float)((double)fArray8[n26] * ((double)f8 * 0.45454545454545453));
                }
                for (n4 = 0; n4 < this.subframeSize; ++n4) {
                    int n27 = n16 + n4;
                    this.excBuf[n27] = this.excBuf[n27] + fArray8[n4];
                }
            }
            n4 = 0;
            while (n4 < this.subframeSize) {
                int n28 = n4++;
                fArray4[n28] = fArray4[n28] * f8;
            }
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                fArray6[n4] = this.mem_sp[n4];
            }
            Filters.iir_mem2(this.excBuf, n16, this.interp_qlpc, this.frmBuf, n2, this.subframeSize, this.lpcSize, this.mem_sp);
            Filters.filter_mem2(this.frmBuf, n2, this.bw_lpc1, this.bw_lpc2, this.swBuf, n17, this.subframeSize, this.lpcSize, this.mem_sw, 0);
            for (n4 = 0; n4 < this.subframeSize; ++n4) {
                this.exc2Buf[n18 + n4] = this.excBuf[n16 + n4];
            }
        }
        if (this.submodeID >= 1) {
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                this.old_lsp[n4] = this.lsp[n4];
            }
            for (n4 = 0; n4 < this.lpcSize; ++n4) {
                this.old_qlsp[n4] = this.qlsp[n4];
            }
        }
        if (this.submodeID == 1) {
            if (this.dtx_count != 0) {
                bits.pack(15, 4);
            } else {
                bits.pack(0, 4);
            }
        }
        this.first = 0;
        float f10 = 0.0f;
        float f11 = 0.0f;
        for (n4 = 0; n4 < this.frameSize; ++n4) {
            f10 += this.frmBuf[this.frmIdx + n4] * this.frmBuf[this.frmIdx + n4];
            f11 += (this.frmBuf[this.frmIdx + n4] - fArray7[n4]) * (this.frmBuf[this.frmIdx + n4] - fArray7[n4]);
        }
        f = (float)(10.0 * Math.log((f10 + 1.0f) / (f11 + 1.0f)));
        fArray[0] = this.frmBuf[this.frmIdx] + this.preemph * this.pre_mem2;
        for (n4 = 1; n4 < this.frameSize; ++n4) {
            fArray[n4] = this.frmBuf[this.frmIdx + n4] + this.preemph * fArray[n4 - 1];
        }
        this.pre_mem2 = fArray[this.frameSize - 1];
        this.bounded_pitch = this.submodes[this.submodeID].innovation instanceof NoiseSearch || this.submodeID == 0 ? 1 : 0;
        return 1;
    }

    public int getEncodedFrameSize() {
        return NB_FRAME_SIZE[this.submodeID];
    }

    public void setQuality(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 10) {
            n = 10;
        }
        this.submodeID = this.submodeSelect = NB_QUALITY_MAP[n];
    }

    public int getBitRate() {
        if (this.submodes[this.submodeID] != null) {
            return this.sampling_rate * this.submodes[this.submodeID].bits_per_frame / this.frameSize;
        }
        return this.sampling_rate * 5 / this.frameSize;
    }

    public void setMode(int n) {
        if (n < 0) {
            n = 0;
        }
        this.submodeID = this.submodeSelect = n;
    }

    public int getMode() {
        return this.submodeID;
    }

    public void setBitRate(int n) {
        for (int i = 10; i >= 0; --i) {
            this.setQuality(i);
            if (this.getBitRate() > n) continue;
            return;
        }
    }

    public void setVbr(boolean bl) {
        this.vbr_enabled = bl ? 1 : 0;
    }

    public boolean getVbr() {
        return this.vbr_enabled != 0;
    }

    public void setVad(boolean bl) {
        this.vad_enabled = bl ? 1 : 0;
    }

    public boolean getVad() {
        return this.vad_enabled != 0;
    }

    public void setDtx(boolean bl) {
        this.dtx_enabled = bl ? 1 : 0;
    }

    public int getAbr() {
        return this.abr_enabled;
    }

    public void setAbr(int n) {
        float f;
        int n2;
        this.abr_enabled = n != 0 ? 1 : 0;
        this.vbr_enabled = 1;
        int n3 = n;
        for (n2 = 10; n2 >= 0; --n2) {
            this.setQuality(n2);
            int n4 = this.getBitRate();
            if (n4 <= n3) break;
        }
        if ((f = (float)n2) < 0.0f) {
            f = 0.0f;
        }
        this.setVbrQuality(f);
        this.abr_count = 0.0f;
        this.abr_drift = 0.0f;
        this.abr_drift2 = 0.0f;
    }

    public void setVbrQuality(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 10.0f) {
            f = 10.0f;
        }
        this.vbr_quality = f;
    }

    public float getVbrQuality() {
        return this.vbr_quality;
    }

    public void setComplexity(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 10) {
            n = 10;
        }
        this.complexity = n;
    }

    public int getComplexity() {
        return this.complexity;
    }

    public void setSamplingRate(int n) {
        this.sampling_rate = n;
    }

    public int getSamplingRate() {
        return this.sampling_rate;
    }

    public int getLookAhead() {
        return this.windowSize - this.frameSize;
    }

    public float getRelativeQuality() {
        return this.relative_quality;
    }
}

