/*
 * Decompiled with CFR 0.152.
 */
package CasseBrique.Core;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public abstract class Objet {
    protected int x;
    protected int y;
    public double vitesse;
    public double direction;
    protected int hauteur;
    protected int largeur;
    public boolean outOfScreen;
    public Rectangle hitBox;
    public Image image;

    public Objet(int haut, int larg, int abs, int ord, Image image) {
        this.hauteur = haut;
        this.largeur = larg;
        this.x = abs;
        this.y = ord;
        this.image = image;
        this.regenBox();
    }

    public Objet(int haut, int larg, int abs, int ord, double dir, double vit, Image image) {
        this.hauteur = haut;
        this.largeur = larg;
        this.x = abs;
        this.y = ord;
        this.vitesse = vit;
        this.direction = dir;
        this.image = image;
        this.regenBox();
    }

    public void regenBox() {
        this.hitBox = new Rectangle(this.x, this.y, this.largeur, this.hauteur);
    }

    public boolean collide(Objet obj) {
        boolean collision = obj.hitBox.intersects(this.hitBox);
        if (collision) {
            this.onCollision(obj);
            obj.onCollision(this);
        }
        return collision;
    }

    public void move(Rectangle borders) {
        if (this.vitesse > 0.0) {
            this.x += (int)(this.vitesse * Math.cos(this.direction));
            this.y += (int)(this.vitesse * Math.sin(this.direction));
            this.hitBox.setLocation(this.x, this.y);
            if (this.x + this.largeur < 0 || this.y + this.hauteur < 0 || (double)this.x > borders.getWidth() || (double)this.y > borders.getHeight()) {
                this.outOfScreen = true;
            }
        }
    }

    public abstract void onCollision(Objet var1);

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
        this.hitBox.setLocation(this.x, this.y);
    }

    public void setY(int y) {
        this.y = y;
        this.hitBox.setLocation(this.x, y);
    }

    public int getHauteur() {
        return this.hauteur;
    }

    public int getLargeur() {
        return this.largeur;
    }

    public void paint(Graphics buffer) {
        if (!this.outOfScreen) {
            buffer.drawImage(this.image, this.x, this.y, null);
        }
    }
}

