/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.CbSearch;
import org.xiph.speex.Filters;
import org.xiph.speex.VQ;

public class SplitShapeSearch
extends CbSearch {
    public static final int MAX_COMPLEXITY = 10;
    private int subframesize;
    private int subvect_size;
    private int nb_subvect;
    private int[] shape_cb;
    private int shape_cb_size;
    private int shape_bits;
    private int have_sign;
    private int[] ind;
    private int[] signs;
    private float[] t;
    private float[] e;
    private float[] E;
    private float[] r2;
    private float[][] ot;
    private float[][] nt;
    private int[][] nind;
    private int[][] oind;

    public SplitShapeSearch(int n, int n2, int n3, int[] nArray, int n4, int n5) {
        this.subframesize = n;
        this.subvect_size = n2;
        this.nb_subvect = n3;
        this.shape_cb = nArray;
        this.shape_bits = n4;
        this.have_sign = n5;
        this.ind = new int[n3];
        this.signs = new int[n3];
        this.shape_cb_size = 1 << n4;
        this.ot = new float[10][n];
        this.nt = new float[10][n];
        this.oind = new int[10][n3];
        this.nind = new int[10][n3];
        this.t = new float[n];
        this.e = new float[n];
        this.r2 = new float[n];
        this.E = new float[this.shape_cb_size];
    }

    public final void quant(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n, int n2, float[] fArray5, int n3, float[] fArray6, Bits bits, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = n4;
        if (n9 > 10) {
            n9 = 10;
        }
        float[] fArray7 = new float[this.shape_cb_size * this.subvect_size];
        int[] nArray = new int[n9];
        float[] fArray8 = new float[n9];
        float[] fArray9 = new float[n9];
        float[] fArray10 = new float[n9];
        for (n8 = 0; n8 < n9; ++n8) {
            for (n7 = 0; n7 < this.nb_subvect; ++n7) {
                this.oind[n8][n7] = -1;
                this.nind[n8][n7] = -1;
            }
        }
        for (n7 = 0; n7 < n9; ++n7) {
            for (n8 = 0; n8 < n2; ++n8) {
                this.ot[n7][n8] = fArray[n8];
            }
        }
        for (n8 = 0; n8 < this.shape_cb_size; ++n8) {
            n6 = n8 * this.subvect_size;
            int n10 = n8 * this.subvect_size;
            for (n7 = 0; n7 < this.subvect_size; ++n7) {
                fArray7[n6 + n7] = 0.0f;
                for (n5 = 0; n5 <= n7; ++n5) {
                    int n11 = n6 + n7;
                    fArray7[n11] = (float)((double)fArray7[n11] + 0.03125 * (double)this.shape_cb[n10 + n5] * (double)fArray6[n7 - n5]);
                }
            }
            this.E[n8] = 0.0f;
            for (n7 = 0; n7 < this.subvect_size; ++n7) {
                int n12 = n8;
                this.E[n12] = this.E[n12] + fArray7[n6 + n7] * fArray7[n6 + n7];
            }
        }
        for (n7 = 0; n7 < n9; ++n7) {
            fArray10[n7] = 0.0f;
        }
        for (n8 = 0; n8 < this.nb_subvect; ++n8) {
            int n13;
            Object object;
            n6 = n8 * this.subvect_size;
            for (n7 = 0; n7 < n9; ++n7) {
                fArray9[n7] = -1.0f;
            }
            for (n7 = 0; n7 < n9; ++n7) {
                if (this.have_sign != 0) {
                    VQ.nbest_sign(this.ot[n7], n6, fArray7, this.subvect_size, this.shape_cb_size, this.E, n9, nArray, fArray8);
                } else {
                    VQ.nbest(this.ot[n7], n6, fArray7, this.subvect_size, this.shape_cb_size, this.E, n9, nArray, fArray8);
                }
                block12: for (n5 = 0; n5 < n9; ++n5) {
                    int n14;
                    int n15;
                    float f = 0.0f;
                    object = this.ot[n7];
                    for (n13 = n6; n13 < n6 + this.subvect_size; ++n13) {
                        this.t[n13] = (float)object[n13];
                    }
                    float f2 = 1.0f;
                    int n16 = nArray[n5];
                    if (n16 >= this.shape_cb_size) {
                        f2 = -1.0f;
                        n16 -= this.shape_cb_size;
                    }
                    int n17 = n16 * this.subvect_size;
                    if (f2 > 0.0f) {
                        for (n13 = 0; n13 < this.subvect_size; ++n13) {
                            int n18 = n6 + n13;
                            this.t[n18] = this.t[n18] - fArray7[n17 + n13];
                        }
                    } else {
                        for (n13 = 0; n13 < this.subvect_size; ++n13) {
                            int n19 = n6 + n13;
                            this.t[n19] = this.t[n19] + fArray7[n17 + n13];
                        }
                    }
                    f = fArray10[n7];
                    for (n13 = n6; n13 < n6 + this.subvect_size; ++n13) {
                        f += this.t[n13] * this.t[n13];
                    }
                    if (!(f < fArray9[n9 - 1]) && !((double)fArray9[n9 - 1] < -0.5)) continue;
                    for (n13 = n6 + this.subvect_size; n13 < n2; ++n13) {
                        this.t[n13] = (float)object[n13];
                    }
                    for (n13 = 0; n13 < this.subvect_size; ++n13) {
                        f2 = 1.0f;
                        n17 = nArray[n5];
                        if (n17 >= this.shape_cb_size) {
                            f2 = -1.0f;
                            n17 -= this.shape_cb_size;
                        }
                        float f3 = f2 * 0.03125f * (float)this.shape_cb[n17 * this.subvect_size + n13];
                        n15 = this.subvect_size - n13;
                        n14 = n6 + this.subvect_size;
                        while (n14 < n2) {
                            int n20 = n14++;
                            this.t[n20] = this.t[n20] - f3 * fArray6[n15];
                            ++n15;
                        }
                    }
                    for (n13 = 0; n13 < n9; ++n13) {
                        if (!(f < fArray9[n13]) && !((double)fArray9[n13] < -0.5)) continue;
                        for (n14 = n9 - 1; n14 > n13; --n14) {
                            for (n15 = n6 + this.subvect_size; n15 < n2; ++n15) {
                                this.nt[n14][n15] = this.nt[n14 - 1][n15];
                            }
                            for (n15 = 0; n15 < this.nb_subvect; ++n15) {
                                this.nind[n14][n15] = this.nind[n14 - 1][n15];
                            }
                            fArray9[n14] = fArray9[n14 - 1];
                        }
                        for (n15 = n6 + this.subvect_size; n15 < n2; ++n15) {
                            this.nt[n13][n15] = this.t[n15];
                        }
                        for (n15 = 0; n15 < this.nb_subvect; ++n15) {
                            this.nind[n13][n15] = this.oind[n7][n15];
                        }
                        this.nind[n13][n8] = nArray[n5];
                        fArray9[n13] = f;
                        continue block12;
                    }
                }
                if (n8 == 0) break;
            }
            object = this.ot;
            this.ot = this.nt;
            this.nt = object;
            for (n7 = 0; n7 < n9; ++n7) {
                for (n13 = 0; n13 < this.nb_subvect; ++n13) {
                    this.oind[n7][n13] = this.nind[n7][n13];
                }
            }
            for (n7 = 0; n7 < n9; ++n7) {
                fArray10[n7] = fArray9[n7];
            }
        }
        for (n8 = 0; n8 < this.nb_subvect; ++n8) {
            this.ind[n8] = this.nind[0][n8];
            bits.pack(this.ind[n8], this.shape_bits + this.have_sign);
        }
        for (n8 = 0; n8 < this.nb_subvect; ++n8) {
            float f = 1.0f;
            n6 = this.ind[n8];
            if (n6 >= this.shape_cb_size) {
                f = -1.0f;
                n6 -= this.shape_cb_size;
            }
            for (n7 = 0; n7 < this.subvect_size; ++n7) {
                this.e[this.subvect_size * n8 + n7] = f * 0.03125f * (float)this.shape_cb[n6 * this.subvect_size + n7];
            }
        }
        for (n7 = 0; n7 < n2; ++n7) {
            int n21 = n3 + n7;
            fArray5[n21] = fArray5[n21] + this.e[n7];
        }
        Filters.syn_percep_zero(this.e, 0, fArray2, fArray3, fArray4, this.r2, n2, n);
        for (n7 = 0; n7 < n2; ++n7) {
            int n22 = n7;
            fArray[n22] = fArray[n22] - this.r2[n7];
        }
    }

    public final void unquant(float[] fArray, int n, int n2, Bits bits) {
        int n3;
        for (n3 = 0; n3 < this.nb_subvect; ++n3) {
            this.signs[n3] = this.have_sign != 0 ? bits.unpack(1) : 0;
            this.ind[n3] = bits.unpack(this.shape_bits);
        }
        for (n3 = 0; n3 < this.nb_subvect; ++n3) {
            float f = 1.0f;
            if (this.signs[n3] != 0) {
                f = -1.0f;
            }
            for (int i = 0; i < this.subvect_size; ++i) {
                int n4 = n + this.subvect_size * n3 + i;
                fArray[n4] = fArray[n4] + f * 0.03125f * (float)this.shape_cb[this.ind[n3] * this.subvect_size + i];
            }
        }
    }
}

