/*
 * Decompiled with CFR 0.152.
 */
package CasseBrique;

import CasseBrique.Bonus.AllongementBarre;
import CasseBrique.Bonus.DoubleBall;
import CasseBrique.Bonus.QuatriemeMur;
import CasseBrique.Bonus.RalentissementBalle;
import CasseBrique.Core.Balle;
import CasseBrique.Core.Barre;
import CasseBrique.Core.Bonus;
import CasseBrique.Core.Briques;
import CasseBrique.Core.Sol;
import CasseBrique.Frames.Defaite;
import CasseBrique.GameTimer;
import CasseBrique.Listeners.KeyControls;
import CasseBrique.Listeners.PauseButton;
import CasseBrique.Panels.GamePanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javazoom.jlgui.basicplayer.BasicController;
import javazoom.jlgui.basicplayer.BasicPlayer;
import javazoom.jlgui.basicplayer.BasicPlayerEvent;
import javazoom.jlgui.basicplayer.BasicPlayerException;
import javazoom.jlgui.basicplayer.BasicPlayerListener;

public class Jeu
extends JFrame {
    private Image Fond;
    private Image BarreImg;
    private Image BalleImg;
    private Image BonusBleu;
    private Image BonusRouge;
    private Image BonusVert;
    private Image BonusViolet;
    private Image BriqueOrange;
    private Image BriqueRouge;
    private Image BriqueVerte;
    private Image BriqueBleu;
    private Image BriqueViolette;
    private Image BriqueGrise;
    private Image MiniBriqueRouge;
    private Image MiniBriqueVerte;
    private Image MiniBriqueGrise;
    private Image MiniBriqueBleu;
    private Image MiniBriqueViolette;
    private Image Vie;
    private Image Pause;
    private Image Play;
    private Image solImage;
    private Image icone;
    private BasicPlayer musicPlayer;
    private HashMap<String, Boolean> keys;
    private JPanel core;
    private JPanel score;
    private JPanel jeu;
    private JLabel affichageScore;
    private JLabel tempsRestant;
    private JButton pauseButton;
    private JLabel life1;
    private JLabel lifesLeft;
    private JLabel BriquesRestantes;
    private Barre barre;
    private ArrayList<Balle> balles;
    private ArrayList<Bonus> bonuses;
    private Briques[][] briques;
    private Sol sol;
    private Rectangle Ecran;
    private Timer monTimer;
    private ConcurrentLinkedQueue<Balle> ballRemovalQueue = new ConcurrentLinkedQueue();
    private int nbVies = 3;
    private int briquesCount = 100;
    private int time = 0;
    private String difficulty;
    public boolean cheatMode = false;
    private static int[] speeds;
    private ArrayList<URL> musicPlaylist = new ArrayList();
    private int points = 0;
    private int pointsNiveau = 0;
    private int nombreDeNiveau = 0;
    private JLabel lesPoints;

    public Jeu(String playerName, String difficulty, boolean cheatMode) {
        this.keys = new HashMap();
        speeds = new int[3];
        this.difficulty = difficulty;
        this.cheatMode = cheatMode;
        if (difficulty.equals("easy")) {
            Jeu.speeds[0] = 8;
            Jeu.speeds[1] = 12;
            Jeu.speeds[2] = 3;
        } else if (difficulty.equals("hard")) {
            Jeu.speeds[0] = 14;
            Jeu.speeds[1] = 16;
            Jeu.speeds[2] = 7;
        } else if (difficulty.equals("bizuth")) {
            Jeu.speeds[0] = 25;
            Jeu.speeds[1] = 15;
            Jeu.speeds[2] = 2;
        } else {
            Jeu.speeds[0] = 11;
            Jeu.speeds[1] = 11;
            Jeu.speeds[2] = 7;
        }
        this.prepareImages();
        this.prepareMusicPlayer();
        this.genererEntites();
        this.genererAffichage(playerName);
        this.monTimer = new Timer(20, new GameTimer(this));
        this.monTimer.start();
    }

    private void prepareImages() {
        Toolkit T = Toolkit.getDefaultToolkit();
        this.Fond = T.getImage(Jeu.class.getResource("/CasseBrique/Images/bg.jpg"));
        this.BarreImg = T.getImage(Jeu.class.getResource("/CasseBrique/Images/barre1.png"));
        this.BalleImg = T.getImage(Jeu.class.getResource("/CasseBrique/Images/balle.png"));
        this.BriqueRouge = T.getImage(Jeu.class.getResource("/CasseBrique/Images/BriqueRouge.png"));
        this.BriqueVerte = T.getImage(Jeu.class.getResource("/CasseBrique/Images/BriqueVerte.png"));
        this.BriqueBleu = T.getImage(Jeu.class.getResource("/CasseBrique/Images/BriqueBleu.png"));
        this.BriqueViolette = T.getImage(Jeu.class.getResource("/CasseBrique/Images/BriqueViolette.png"));
        this.BriqueOrange = T.getImage(Jeu.class.getResource("/CasseBrique/Images/briqueorange.png"));
        this.BriqueGrise = T.getImage(Jeu.class.getResource("/CasseBrique/Images/BriqueGrise.png"));
        this.MiniBriqueRouge = T.getImage(Jeu.class.getResource("/CasseBrique/Images/miniBriqueRouge.png"));
        this.MiniBriqueVerte = T.getImage(Jeu.class.getResource("/CasseBrique/Images/miniBriqueVerte.png"));
        this.MiniBriqueBleu = T.getImage(Jeu.class.getResource("/CasseBrique/Images/miniBriqueBleu.png"));
        this.MiniBriqueViolette = T.getImage(Jeu.class.getResource("/CasseBrique/Images/miniBriqueViolette.png"));
        this.MiniBriqueGrise = T.getImage(Jeu.class.getResource("/CasseBrique/Images/miniBriqueGrise.png"));
        this.Vie = T.getImage(Jeu.class.getResource("/CasseBrique/Images/life.png"));
        this.Pause = T.getImage(Jeu.class.getResource("/CasseBrique/Images/pause.png"));
        this.Play = T.getImage(Jeu.class.getResource("/CasseBrique/Images/play.png"));
        this.BonusBleu = T.getImage(Jeu.class.getResource("/CasseBrique/Images/bonusBleu.png"));
        this.BonusRouge = T.getImage(Jeu.class.getResource("/CasseBrique/Images/bonusRouge.png"));
        this.BonusVert = T.getImage(Jeu.class.getResource("/CasseBrique/Images/bonusVert.png"));
        this.BonusViolet = T.getImage(Jeu.class.getResource("/CasseBrique/Images/bonusViolet.png"));
        this.solImage = T.getImage(Jeu.class.getResource("/CasseBrique/Images/sol.jpg"));
        this.icone = T.getImage(Jeu.class.getResource("/CasseBrique/Images/icone.png"));
    }

    private void genererEntites() {
        int i;
        this.barre = new Barre(22, 177, 300, 625, 0.0, speeds[1], this.BarreImg);
        this.balles = new ArrayList();
        this.bonuses = new ArrayList();
        if (this.difficulty.equals("bizuth")) {
            for (i = 0; i < 100; ++i) {
                this.addBall();
            }
        } else {
            this.addBall();
        }
        this.sol = new Sol(400, 1000, 0, 660, this.solImage, this.ballRemovalQueue);
        this.briques = new Briques[12][9];
        for (i = 0; i < 12; ++i) {
            for (int j = 0; j < 9; ++j) {
                double remplissage = Math.random();
                Image laBrique = null;
                double probaNoBall = 0.15;
                if (this.difficulty.equals("easy")) {
                    probaNoBall = 0.25;
                } else if (this.difficulty.equals("hard")) {
                    probaNoBall = 0.2;
                    if (remplissage > 0.1 && remplissage < probaNoBall) {
                        laBrique = this.BriqueGrise;
                    }
                } else if (this.difficulty.equals("bizuth")) {
                    probaNoBall = 0.3;
                }
                if (remplissage > probaNoBall && remplissage < 0.9) {
                    laBrique = this.BriqueOrange;
                }
                if (remplissage > 0.9 && remplissage < 0.91) {
                    laBrique = this.BriqueRouge;
                }
                if (remplissage > 0.91 && remplissage < 0.95) {
                    laBrique = this.BriqueVerte;
                }
                if (remplissage > 0.95 && remplissage < 0.975) {
                    laBrique = this.BriqueBleu;
                }
                if (remplissage > 0.975 && remplissage < 1.0) {
                    laBrique = this.BriqueViolette;
                }
                if (laBrique != null) {
                    Bonus toAdd;
                    this.briques[i][j] = new Briques(35, 83, 83 * i + 5, 35 * j + 30, laBrique);
                    if (laBrique == this.BriqueBleu) {
                        toAdd = new DoubleBall(0, 0, this.BonusBleu, this.bonuses, this.balles);
                        this.bonuses.add(toAdd);
                        this.briques[i][j].linkBonus(toAdd);
                        continue;
                    }
                    if (laBrique == this.BriqueViolette) {
                        RalentissementBalle toAdd2 = new RalentissementBalle(0, 0, this.BonusViolet, this.bonuses, this.balles);
                        this.bonuses.add(toAdd2);
                        this.briques[i][j].linkBonus(toAdd2);
                        continue;
                    }
                    if (laBrique == this.BriqueVerte) {
                        toAdd = new AllongementBarre(0, 0, this.BonusVert, this.bonuses, this.barre);
                        this.bonuses.add(toAdd);
                        this.briques[i][j].linkBonus(toAdd);
                        continue;
                    }
                    if (laBrique == this.BriqueRouge) {
                        toAdd = new QuatriemeMur(0, 0, this.BonusRouge, this.bonuses, this.sol);
                        this.bonuses.add(toAdd);
                        this.briques[i][j].linkBonus(toAdd);
                        continue;
                    }
                    if (laBrique != this.BriqueGrise) continue;
                    this.briques[i][j].setLife(5);
                    continue;
                }
                this.briques[i][j] = new Briques(0, 0, -2000, -2000, this.BriqueBleu);
                this.briques[i][j].outOfScreen = true;
            }
        }
    }

    private void genererAffichage(String nomJoueur) {
        this.setTitle("Casse brique");
        this.setLayout(null);
        this.setBounds(0, 0, 1200, 700);
        this.setVisible(true);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setIconImage(this.icone);
        this.jeu = new GamePanel(1000, this.getHeight() - 10, 0, 0, this.briques, this.barre, this.balles, this.bonuses, this.sol, this.Fond);
        Font police1 = new Font("Arial", 1, 14);
        Font police2 = new Font("Arial", 1, 18);
        Font police3 = new Font("Arial", 1, 10);
        Font policeLife = new Font("Arial", 1, 22);
        JPanel score = new JPanel();
        score.setBounds(1000, 0, 300, 700);
        score.setLayout(null);
        score.setBackground(Color.BLACK);
        score.setForeground(Color.WHITE);
        JLabel titre = new JLabel("Casse Brique");
        Font police = new Font("Arial", 1, 26);
        titre.setFont(police);
        titre.setBounds(20, 0, 300, 100);
        titre.setForeground(Color.WHITE);
        score.add(titre);
        JLabel joueur = new JLabel("Joueur");
        joueur.setFont(police1);
        joueur.setBounds(40, 70, 300, 20);
        joueur.setForeground(Color.WHITE);
        score.add(joueur);
        JLabel joueurName = new JLabel(nomJoueur);
        joueurName.setFont(police2);
        joueurName.setBounds(40, 100, 300, 20);
        joueurName.setForeground(Color.WHITE);
        score.add(joueurName);
        JLabel temps = new JLabel("Temps \u00e9coul\u00e9");
        temps.setFont(police1);
        temps.setBounds(40, 150, 300, 20);
        temps.setForeground(Color.WHITE);
        score.add(temps);
        this.tempsRestant = new JLabel("");
        this.tempsRestant.setFont(policeLife);
        this.tempsRestant.setBounds(40, temps.getY() + temps.getHeight() + 10, 300, 20);
        this.tempsRestant.setForeground(Color.WHITE);
        score.add(this.tempsRestant);
        JLabel record = new JLabel("Score");
        record.setFont(police1);
        record.setBounds(40, 180, 300, 100);
        record.setForeground(Color.WHITE);
        score.add(record);
        this.lesPoints = new JLabel();
        this.lesPoints.setFont(policeLife);
        this.lesPoints.setBounds(40, 240, 200, 20);
        this.lesPoints.setForeground(Color.WHITE);
        this.lesPoints.setText(Integer.toString(this.points));
        score.add(this.lesPoints);
        JLabel vies = new JLabel("Vies restantes");
        vies.setFont(police1);
        vies.setBounds(40, 250, 300, 100);
        vies.setForeground(Color.WHITE);
        score.add(vies);
        this.life1 = new JLabel(new ImageIcon(this.Vie));
        this.life1.setBounds(40, 307, 40, 40);
        this.lifesLeft = new JLabel("x " + this.nbVies);
        this.lifesLeft.setFont(policeLife);
        this.lifesLeft.setForeground(Color.WHITE);
        this.lifesLeft.setBounds(90, 280, 150, 100);
        score.add(this.lifesLeft);
        score.add(this.life1);
        JLabel briquesRestantes = new JLabel("Briques restantes");
        briquesRestantes.setFont(police1);
        briquesRestantes.setBounds(40, 320, 300, 100);
        briquesRestantes.setForeground(Color.WHITE);
        score.add(briquesRestantes);
        this.BriquesRestantes = new JLabel();
        this.BriquesRestantes.setFont(police1);
        this.BriquesRestantes.setBounds(40, 370, 40, 40);
        this.BriquesRestantes.setForeground(Color.WHITE);
        this.BriquesRestantes.setText(Integer.toString(this.briquesCount));
        score.add(this.BriquesRestantes);
        JLabel bonus = new JLabel("Bonus");
        bonus.setFont(police1);
        bonus.setBounds(40, 380, 300, 100);
        bonus.setForeground(Color.WHITE);
        score.add(bonus);
        JLabel bonusBarre = new JLabel("Barre Agrandie");
        JLabel bonusVitesse = new JLabel("Balles Ralenties");
        JLabel bonusBrique = new JLabel("Super-briques (5 coups)");
        JLabel bonusBalle = new JLabel("Multi-balles");
        JLabel bonusSol = new JLabel("Quatri\u00e8me Mur");
        bonusBarre.setFont(police3);
        bonusVitesse.setFont(police3);
        bonusBalle.setFont(police3);
        bonusBrique.setFont(police3);
        bonusSol.setFont(police3);
        bonusBarre.setBounds(65, 448, 300, 10);
        bonusVitesse.setBounds(bonusBarre.getX(), bonusBarre.getY() + bonusBarre.getHeight() + 13, 300, 10);
        bonusBrique.setBounds(bonusBarre.getX(), bonusVitesse.getY() + bonusVitesse.getHeight() + 13, 300, 10);
        bonusBalle.setBounds(bonusBarre.getX(), bonusBrique.getY() + bonusBrique.getHeight() + 13, 300, 10);
        bonusSol.setBounds(bonusBarre.getX(), bonusBalle.getY() + bonusBalle.getHeight() + 13, 300, 10);
        bonusBarre.setForeground(Color.WHITE);
        bonusVitesse.setForeground(Color.WHITE);
        bonusBrique.setForeground(Color.WHITE);
        bonusBalle.setForeground(Color.WHITE);
        bonusSol.setForeground(Color.WHITE);
        score.add(bonusBarre);
        score.add(bonusVitesse);
        score.add(bonusBrique);
        score.add(bonusBalle);
        score.add(bonusSol);
        JLabel labelMiniBriqueVerte = new JLabel(new ImageIcon(this.MiniBriqueVerte));
        JLabel labelMiniBriqueViolette = new JLabel(new ImageIcon(this.MiniBriqueViolette));
        JLabel labelMiniBriqueGrise = new JLabel(new ImageIcon(this.MiniBriqueGrise));
        JLabel labelMiniBriqueBleu = new JLabel(new ImageIcon(this.MiniBriqueBleu));
        JLabel labelMiniBriqueRouge = new JLabel(new ImageIcon(this.MiniBriqueRouge));
        labelMiniBriqueVerte.setBounds(15, 445, 42, 18);
        labelMiniBriqueViolette.setBounds(labelMiniBriqueVerte.getX(), labelMiniBriqueVerte.getY() + labelMiniBriqueVerte.getHeight() + 5, 42, 18);
        labelMiniBriqueGrise.setBounds(labelMiniBriqueVerte.getX(), labelMiniBriqueViolette.getY() + labelMiniBriqueViolette.getHeight() + 5, 42, 18);
        labelMiniBriqueBleu.setBounds(labelMiniBriqueVerte.getX(), labelMiniBriqueGrise.getY() + labelMiniBriqueGrise.getHeight() + 5, 42, 18);
        labelMiniBriqueRouge.setBounds(labelMiniBriqueVerte.getX(), labelMiniBriqueBleu.getY() + labelMiniBriqueBleu.getHeight() + 5, 42, 18);
        score.add(labelMiniBriqueVerte);
        score.add(labelMiniBriqueViolette);
        score.add(labelMiniBriqueGrise);
        score.add(labelMiniBriqueBleu);
        score.add(labelMiniBriqueRouge);
        this.pauseButton = new JButton(new ImageIcon(this.Pause));
        this.pauseButton.setBounds(50, 570, 105, 75);
        this.pauseButton.addMouseListener(new PauseButton(this));
        score.add(this.pauseButton);
        this.Ecran = new Rectangle(0, 0, this.jeu.getWidth(), this.jeu.getHeight());
        this.core = new JPanel();
        this.core.setBounds(0, 0, 1200, 700);
        this.core.setLayout(null);
        this.core.setBackground(Color.black);
        this.core.add(score);
        this.core.add(this.jeu);
        this.setContentPane(this.core);
        this.jeu.addKeyListener(new KeyControls(this));
        this.jeu.grabFocus();
    }

    private void prepareMusicPlayer() {
        this.musicPlaylist.add(Jeu.class.getResource("/CasseBrique/Music/arpanauts.wav"));
        this.musicPlaylist.add(Jeu.class.getResource("/CasseBrique/Music/hhavok_intro.wav"));
        this.musicPlaylist.add(Jeu.class.getResource("/CasseBrique/Music/jumpshot.wav"));
        this.musicPlaylist.add(Jeu.class.getResource("/CasseBrique/Music/resistors.wav"));
        this.musicPlaylist.add(Jeu.class.getResource("/CasseBrique/Music/prologue.wav"));
        Collections.shuffle(this.musicPlaylist, new Random());
        this.musicPlayer = new BasicPlayer();
        try {
            this.musicPlayer.open(this.musicPlaylist.get(0));
            this.musicPlayer.play();
            this.musicPlayer.setGain(0.2);
            this.musicPlayer.addBasicPlayerListener(new BasicPlayerListener(){
                private int count = 1;

                @Override
                public void opened(Object o, Map map) {
                }

                @Override
                public void progress(int i, long l, byte[] bytes, Map map) {
                }

                @Override
                public void stateUpdated(BasicPlayerEvent basicPlayerEvent) {
                    if (basicPlayerEvent.getCode() == 3) {
                        try {
                            Jeu.this.musicPlayer.open((URL)Jeu.this.musicPlaylist.get(this.count));
                            Jeu.this.musicPlayer.play();
                            Jeu.this.musicPlayer.setGain(0.2);
                            ++this.count;
                            if (this.count > Jeu.this.musicPlaylist.size() - 1) {
                                this.count = 0;
                            }
                        }
                        catch (BasicPlayerException e) {
                            e.printStackTrace();
                        }
                    }
                }

                @Override
                public void setController(BasicController basicController) {
                }
            });
        }
        catch (BasicPlayerException e) {
            e.printStackTrace();
        }
    }

    public void gestionBonuses() {
        for (int i = this.bonuses.size() - 1; i >= 0; --i) {
            Bonus bonus = this.bonuses.get(i);
            if (bonus != null && !bonus.outOfScreen) {
                bonus.move(this.Ecran);
                bonus.collide(this.barre);
                continue;
            }
            if (bonus == null || bonus.vitesse == 0.0) continue;
            this.bonuses.remove(bonus);
        }
    }

    public void gestionBarre() {
        if (this.keys.getOrDefault("droite", false).booleanValue()) {
            this.barre.vitesse = speeds[1];
            this.barre.direction = 0.0;
            this.barre.move(this.Ecran);
        } else {
            this.barre.vitesse = 0.0;
        }
        if (this.keys.getOrDefault("gauche", false).booleanValue()) {
            this.barre.vitesse = speeds[1];
            this.barre.direction = Math.PI;
            this.barre.move(this.Ecran);
        } else {
            this.barre.vitesse = 0.0;
        }
    }

    public void gestionBalles() {
        Balle balle;
        if (this.balles.size() == 0) {
            this.lostLife();
        }
        for (Balle balle2 : this.balles) {
            if (balle2 == null) continue;
            balle2.move(this.Ecran);
            balle2.collide(this.barre);
            balle2.collide(this.sol);
            Briques[][] briquesArray = this.briques;
            int n = briquesArray.length;
            for (int i = 0; i < n; ++i) {
                Briques[] briqueTab;
                for (Briques brique : briqueTab = briquesArray[i]) {
                    balle2.collide(brique);
                }
            }
        }
        while ((balle = this.ballRemovalQueue.poll()) != null) {
            this.balles.remove(balle);
        }
    }

    public void releaseBalls() {
        for (Balle balle : this.balles) {
            if (balle == null || !balle.isLinked()) continue;
            balle.setLinkedTo(null);
            balle.genRandomAngle();
            balle.vitesse = speeds[0];
        }
    }

    public void addBall() {
        Balle balle = new Balle(18, 18, 0, 0, 0.0, 0.0, this.BalleImg);
        balle.setX(this.barre.getX() + this.barre.getLargeur() / 2 - balle.getLargeur() / 2);
        balle.setY(this.barre.getY() - this.barre.getHauteur() / 2 - balle.getHauteur() / 2);
        balle.setLinkedTo(this.barre);
        this.balles.add(balle);
    }

    public void resetFocus() {
        this.jeu.grabFocus();
    }

    public boolean isRunning() {
        return this.monTimer.isRunning();
    }

    public void switchState() {
        if (this.monTimer.isRunning()) {
            this.monTimer.stop();
            this.pauseButton.setIcon(new ImageIcon(this.Play));
            try {
                this.musicPlayer.pause();
            }
            catch (BasicPlayerException e) {
                e.printStackTrace();
            }
        } else {
            this.monTimer.start();
            this.pauseButton.setIcon(new ImageIcon(this.Pause));
            try {
                this.musicPlayer.resume();
            }
            catch (BasicPlayerException e) {
                e.printStackTrace();
            }
        }
    }

    private void lostLife() {
        --this.nbVies;
        this.lifesLeft.setText("x " + this.nbVies);
        if (this.nbVies == 0) {
            this.monTimer.stop();
            this.dispose();
            try {
                this.musicPlayer.pause();
            }
            catch (BasicPlayerException e) {
                e.printStackTrace();
            }
            int scoreFinal = this.points + this.nombreDeNiveau * 800 / this.time;
            Defaite defaite = new Defaite(scoreFinal);
        }
        this.addBall();
    }

    public void addSecond() {
        ++this.time;
        int hours = this.time / 3600;
        int minutes = this.time / 60;
        int seconds = this.time - minutes * 60;
        String text = "";
        if (hours > 0) {
            text = text + hours + "h ";
        }
        if (minutes > 0) {
            text = text + minutes + "m ";
        }
        text = text + seconds + "s";
        this.tempsRestant.setText(text);
    }

    public static int getSpeed(String object) {
        if (object.equals("bonus")) {
            return speeds[2];
        }
        if (object.equals("barre")) {
            return speeds[1];
        }
        return speeds[0];
    }

    public void briquesRestantes() {
        this.briquesCount = 0;
        int compte = 0;
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.briques[i][j] != null && !this.briques[i][j].outOfScreen) {
                    ++this.briquesCount;
                }
                if (this.briques[i][j] == null || this.briques[i][j].getX() != -1000) continue;
                ++compte;
            }
        }
        this.BriquesRestantes.setText(Integer.toString(this.briquesCount));
        this.augmentationScore(compte * 100);
        if (this.briquesCount == 0) {
            this.regenererNiveau();
        }
    }

    private void regenererNiveau() {
        this.augmentationScoreNiveau(this.points);
        this.monTimer.stop();
        Bonus.clearBonusList();
        this.incrementationVitesses();
        this.genererEntites();
        this.core.remove(this.jeu);
        this.jeu = new GamePanel(1000, this.getHeight() - 10, 0, 0, this.briques, this.barre, this.balles, this.bonuses, this.sol, this.Fond);
        this.core.add(this.jeu);
        this.jeu.addKeyListener(new KeyControls(this));
        this.jeu.grabFocus();
        ++this.nombreDeNiveau;
        this.monTimer.start();
    }

    public String getDifficulty() {
        return this.difficulty;
    }

    public void setKeyStatus(String key, boolean status) {
        this.keys.put(key, status);
    }

    private void augmentationScore(int augmentation) {
        this.points = augmentation + this.pointsNiveau;
        this.lesPoints.setText(Integer.toString(this.points));
    }

    private void augmentationScoreNiveau(int augmentation) {
        this.pointsNiveau += augmentation;
        this.lesPoints.setText(Integer.toString(this.pointsNiveau));
    }

    private void incrementationVitesses() {
        int i = 0;
        while (i < speeds.length) {
            int n = i++;
            speeds[n] = (int)((double)speeds[n] + 1.5);
        }
    }
}

